/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.common.meteor.MeteorLayer;

public class MeteorRecipeBuilder
extends BloodMagicRecipeBuilder<MeteorRecipeBuilder> {
    private final Ingredient input;
    private final int syphon;
    private final float explosionRadius;
    private final List<MeteorLayer> layerList;

    protected MeteorRecipeBuilder(Ingredient input, int syphon, float explosionRadius, List<MeteorLayer> layerList) {
        super(MeteorRecipeBuilder.bmSerializer("meteor"));
        this.input = input;
        this.syphon = syphon;
        this.explosionRadius = explosionRadius;
        this.layerList = layerList;
    }

    public static MeteorRecipeBuilder meteor(Ingredient input, int syphon, float explosionRadius) {
        return new MeteorRecipeBuilder(input, syphon, explosionRadius, new ArrayList<MeteorLayer>());
    }

    public MeteorRecipeBuilder addLayer(MeteorLayer layer) {
        this.layerList.add(layer);
        return this;
    }

    @Override
    protected MeteorRecipeResult getResult(ResourceLocation id) {
        return new MeteorRecipeResult(id);
    }

    public class MeteorRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected MeteorRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("input", MeteorRecipeBuilder.this.input.func_200304_c());
            json.addProperty("syphon", (Number)MeteorRecipeBuilder.this.syphon);
            json.addProperty("explosion", (Number)MeteorRecipeBuilder.this.syphon);
            if (MeteorRecipeBuilder.this.layerList.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (MeteorLayer layer : MeteorRecipeBuilder.this.layerList) {
                    mainArray.add((JsonElement)layer.serialize());
                }
                json.add("layers", (JsonElement)mainArray);
            }
        }
    }
}

