/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.item.inventory.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.BasicFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.common.routing.BasicItemFilter;
import wayoftime.bloodmagic.common.routing.BlacklistItemFilter;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;
import wayoftime.bloodmagic.util.Utils;

public class ItemRouterFilter
extends Item
implements INamedContainerProvider,
IItemFilterProvider {
    public static final int inventorySize = 9;
    public static final int maxUpgrades = 9;
    public static final String FILTER_INV = "filterInventory";

    public ItemRouterFilter() {
        super(new Item.Properties().func_200917_a(16).func_200916_a(BloodMagic.TAB));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            Utils.setUUID(stack);
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.writeItemStack(stack, false));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity player) {
        assert (player.func_130014_f_() != null);
        return new ContainerFilter(p_createMenu_1_, player, p_createMenu_2_, player.func_184614_ca());
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Filter");
    }

    @Override
    public ItemStack getContainedStackForItem(ItemStack filterStack, ItemStack keyStack) {
        ItemStack copyStack = keyStack.func_77946_l();
        GhostItemHelper.setItemGhostAmount(copyStack, 0);
        copyStack.func_190920_e(1);
        return copyStack;
    }

    protected IItemFilter getFilterTypeFromConfig(ItemStack filterStack) {
        int state = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        if (state == 1) {
            return new BlacklistItemFilter();
        }
        return new BasicItemFilter();
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        return new BasicFilterKey(ghostStack, amount);
    }

    @Override
    public IItemFilter getInputItemFilter(ItemStack filterStack, TileEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            IFilterKey key = this.getFilterKey(filterStack, i, ghostStack, amount);
            filteredList.add(key);
        }
        testFilter.initializeFilter(filteredList, tile, handler, false);
        return testFilter;
    }

    @Override
    public IItemFilter getOutputItemFilter(ItemStack filterStack, TileEntity tile, IItemHandler handler) {
        IItemFilter testFilter = this.getFilterTypeFromConfig(filterStack);
        ArrayList<IFilterKey> filteredList = new ArrayList<IFilterKey>();
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int amount = GhostItemHelper.getItemGhostAmount(stack);
            ItemStack ghostStack = GhostItemHelper.getSingleStackFromGhost(stack);
            if (amount == 0) {
                amount = Integer.MAX_VALUE;
            }
            IFilterKey key = this.getFilterKey(filterStack, i, ghostStack, amount);
            filteredList.add(key);
        }
        testFilter.initializeFilter(filteredList, tile, handler, true);
        return testFilter;
    }

    @Override
    public void setGhostItemAmount(ItemStack filterStack, int ghostItemSlot, int amount) {
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack stack = inv.func_70301_a(ghostItemSlot);
        if (!stack.func_190926_b()) {
            GhostItemHelper.setItemGhostAmount(stack, amount);
            inv.writeToStack(filterStack);
        }
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag == null) {
            filterStack.func_77982_d(new CompoundNBT());
            tag = filterStack.func_77978_p();
        }
        if (buttonKey.equals("blackwhitelist")) {
            int nextState = 0;
            switch (currentButtonState) {
                case 0: {
                    nextState = 1;
                    break;
                }
                default: {
                    nextState = 0;
                }
            }
            tag.func_74768_a("button:blackwhitelist", nextState);
            return nextState;
        }
        return -1;
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundNBT tag = filterStack.func_77978_p();
        if (tag != null && buttonKey.equals("blackwhitelist")) {
            int state = tag.func_74762_e("button:blackwhitelist");
            return state;
        }
        return -1;
    }

    @Override
    public List<ITextComponent> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        ArrayList<ITextComponent> componentList = new ArrayList<ITextComponent>();
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentState) {
                case 1: {
                    componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.blacklist"));
                    break;
                }
                default: {
                    componentList.add((ITextComponent)new TranslationTextComponent("filter.bloodmagic.whitelist"));
                }
            }
        }
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.IPressable>> getButtonAction(ContainerFilter container) {
        ArrayList<Pair<String, Button.IPressable>> buttonList = new ArrayList<Pair<String, Button.IPressable>>();
        buttonList.add(Pair.of((Object)"blackwhitelist", (Object)new FilterButtonTogglePress("blackwhitelist", container)));
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("blackwhitelist")) {
            switch (currentButtonState) {
                case 1: {
                    return Pair.of((Object)176, (Object)20);
                }
            }
            return Pair.of((Object)176, (Object)0);
        }
        return Pair.of((Object)0, (Object)0);
    }

    @Override
    public boolean isButtonGlobal(ItemStack filterStack, String buttonKey) {
        return buttonKey.equals("blackwhitelist");
    }
}

