/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.common.loot.BloodMagicLootFunctionManager;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;

public class SetLivingUpgrade
extends LootFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RandomValueRange pointsRange;
    private final List<ResourceLocation> livingUpgrades;

    private SetLivingUpgrade(ILootCondition[] conditionsIn, List<ResourceLocation> livingUpgrades, RandomValueRange damageRangeIn) {
        super(conditionsIn);
        this.pointsRange = damageRangeIn;
        this.livingUpgrades = livingUpgrades;
    }

    public LootFunctionType func_230425_b_() {
        return BloodMagicLootFunctionManager.SET_LIVING_UPGRADE;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        if (stack.func_77973_b() instanceof ILivingContainer) {
            Collections.shuffle(this.livingUpgrades);
            ResourceLocation upgrade = this.livingUpgrades.get(0);
            float points = this.pointsRange.func_186507_b(context.func_216032_b());
            LivingStats stats = new LivingStats();
            stats.addExperience(upgrade, points);
            ((ILivingContainer)stack.func_77973_b()).updateLivingStats(stack, stats);
        } else {
            LOGGER.warn("Couldn't set will of loot item {}", (Object)stack);
        }
        return stack;
    }

    public static LootFunction.Builder<?> withRange(RandomValueRange p_215931_0_, ResourceLocation ... livingUpgrades) {
        return SetLivingUpgrade.func_215860_a(p_215930_1_ -> {
            ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
            for (ResourceLocation resource : livingUpgrades) {
                list.add(resource);
            }
            return new SetLivingUpgrade((ILootCondition[])p_215930_1_, (List<ResourceLocation>)list, p_215931_0_);
        });
    }

    public static class Serializer
    extends LootFunction.Serializer<SetLivingUpgrade> {
        public void serialize(JsonObject json, SetLivingUpgrade p_230424_2_, JsonSerializationContext context) {
            super.func_230424_a_(json, (LootFunction)p_230424_2_, context);
            if (p_230424_2_.livingUpgrades.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (ResourceLocation ing : p_230424_2_.livingUpgrades) {
                    mainArray.add(ing.toString());
                }
                json.add("upgrades", (JsonElement)mainArray);
            }
            json.add("points", context.serialize((Object)p_230424_2_.pointsRange));
        }

        public SetLivingUpgrade deserialize(JsonObject json, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            ArrayList<ResourceLocation> inputList = new ArrayList<ResourceLocation>();
            if (json.has("upgrades") && JSONUtils.func_151202_d((JsonObject)json, (String)"upgrades")) {
                JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"upgrades");
                for (JsonElement element : mainArray) {
                    String resource = element.getAsString();
                    inputList.add(new ResourceLocation(resource));
                }
            }
            return new SetLivingUpgrade(conditionsIn, inputList, (RandomValueRange)JSONUtils.func_188174_a((JsonObject)json, (String)"points", (JsonDeserializationContext)deserializationContext, RandomValueRange.class));
        }
    }
}

