/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.recipe.flask.RecipePotionIncreaseLength;

public class PotionIncreaseLengthRecipeSerializer<RECIPE extends RecipePotionIncreaseLength>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public PotionIncreaseLengthRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        if (json.has("input") && JSONUtils.func_151202_d((JsonObject)json, (String)"input")) {
            JsonArray mainArray = JSONUtils.func_151214_t((JsonObject)json, (String)"input");
            for (JsonElement element : mainArray) {
                if (inputList.size() >= 5) break;
                if (element.isJsonArray()) {
                    element = element.getAsJsonArray();
                } else {
                    element.getAsJsonObject();
                }
                inputList.add(Ingredient.func_199802_a((JsonElement)element));
            }
        }
        int syphon = JSONUtils.func_151203_m((JsonObject)json, (String)"syphon");
        int ticks = JSONUtils.func_151203_m((JsonObject)json, (String)"ticks");
        int minimumTier = JSONUtils.func_151203_m((JsonObject)json, (String)"upgradeLevel");
        Effect outputEffect = BloodMagicPotions.getEffect(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"effect")));
        double lengthDurationMod = JSONUtils.func_151217_k((JsonObject)json, (String)"lengthDurMod");
        return this.factory.create(recipeId, inputList, outputEffect, lengthDurationMod, syphon, ticks, minimumTier);
    }

    public RECIPE read(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        int size = buffer.readInt();
        ArrayList<Ingredient> input = new ArrayList<Ingredient>(size);
        for (int i = 0; i < size; ++i) {
            input.add(i, Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        int syphon = buffer.readInt();
        int ticks = buffer.readInt();
        int minimumTier = buffer.readInt();
        Effect outputEffect = Effect.func_188412_a((int)buffer.readInt());
        double lengthDurationMod = buffer.readDouble();
        return this.factory.create(recipeId, input, outputEffect, lengthDurationMod, syphon, ticks, minimumTier);
    }

    public void write(@Nonnull PacketBuffer buffer, @Nonnull RECIPE recipe) {
        ((RecipePotionIncreaseLength)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipePotionIncreaseLength> {
        public RECIPE create(ResourceLocation var1, List<Ingredient> var2, Effect var3, double var4, int var6, int var7, int var8);
    }
}

