/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;

public class AlchemyArrayProcessor
implements IComponentProcessor {
    private RecipeAlchemyArray recipe;

    public void setup(IVariableProvider variables) {
        IRecipe recipe;
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        Optional recipeHandler = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(id);
        if (recipeHandler.isPresent() && (recipe = (IRecipe)Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(id).get()).func_222127_g().equals(BloodMagicRecipeType.ARRAY)) {
            this.recipe = (RecipeAlchemyArray)recipe;
        }
        if (this.recipe == null) {
            LogManager.getLogger().warn("Guidebook missing Alchemy Array recipe {}", (Object)id);
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        switch (key) {
            case "baseinput": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getBaseInput().func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "addedinput": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getAddedInput().func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "output": {
                return IVariable.from((Object)this.recipe.getOutput());
            }
        }
        return null;
    }
}

