/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ILivingUpgradePointsProvider;
import wayoftime.bloodmagic.common.item.ItemLivingTomeScrap;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeLivingDowngrade;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="downgrade")
public class RitualLivingDowngrade
extends Ritual {
    public static final String DOWNGRADE_RANGE = "containmentRange";

    public RitualLivingDowngrade() {
        super("ritualDowngrade", 0, 10000, "ritual.bloodmagic.downgradeRitual");
        this.addBlockRange(DOWNGRADE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 0, -1), 3));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        int requiredPoints;
        World world = masterRitualStone.getWorldObj();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        Direction direction = masterRitualStone.getDirection();
        PlayerEntity selectedPlayer = null;
        AreaDescriptor downgradeRange = masterRitualStone.getBlockRange(DOWNGRADE_RANGE);
        for (PlayerEntity player : world.func_217357_a(PlayerEntity.class, downgradeRange.getAABB(masterRitualStone.getMasterBlockPos()))) {
            if (player.func_213453_ef() || !LivingUtil.hasFullSet(player)) continue;
            selectedPlayer = player;
            break;
        }
        if (selectedPlayer == null) {
            return;
        }
        LivingStats playerStats = LivingStats.fromPlayer(selectedPlayer, true);
        BlockPos chestOffsetPos = new BlockPos(0, 1, 0);
        BlockPos chestPos = masterPos.func_177971_a((Vector3i)(chestOffsetPos = chestOffsetPos.func_177967_a(direction, 2)));
        TileEntity tile = world.func_175625_s(chestPos);
        if (tile == null) {
            return;
        }
        HashMap<Object, Integer> downgradeMap = new HashMap<Object, Integer>();
        int availablePoints = 0;
        Direction accessDir = Direction.DOWN;
        HashMap priorityMap = new HashMap();
        LazyOptional capability = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, accessDir);
        if (capability.isPresent()) {
            IItemHandler handler = (IItemHandler)capability.resolve().get();
            for (int i = 0; i < handler.getSlots(); ++i) {
                int priority;
                ItemStack invStack = handler.getStackInSlot(i);
                availablePoints += this.getAvailablePointsFromStack(invStack);
                LivingUpgrade downgrade = this.getDowngradeFromStack(world, invStack);
                if (downgrade != null && downgrade != LivingUpgrade.DUMMY) {
                    int wantedLevel = this.getLevelFromStack(invStack);
                    downgradeMap.put((Object)downgrade, downgradeMap.getOrDefault((Object)downgrade, 0) + wantedLevel);
                }
                if ((priority = this.getPriorityFromStack(invStack)) < 0) continue;
                if (priorityMap.containsKey(priority)) {
                    ((List)priorityMap.get(priority)).add(i);
                    continue;
                }
                ArrayList<Integer> priorityList = new ArrayList<Integer>();
                priorityList.add(i);
                priorityMap.put(priority, priorityList);
            }
        } else if (tile instanceof IInventory) {
            for (int i = 0; i < ((IInventory)tile).func_70302_i_(); ++i) {
                int priority;
                ItemStack invStack = ((IInventory)tile).func_70301_a(i);
                availablePoints += this.getAvailablePointsFromStack(invStack);
                Object downgrade = this.getDowngradeFromStack(world, invStack);
                if (downgrade != null && downgrade != LivingUpgrade.DUMMY) {
                    int wantedLevel = this.getLevelFromStack(invStack);
                    downgradeMap.put(downgrade, downgradeMap.getOrDefault(downgrade, 0) + wantedLevel);
                }
                if ((priority = this.getPriorityFromStack(invStack)) < 0) continue;
                if (priorityMap.containsKey(priority)) {
                    ((List)priorityMap.get(priority)).add(i);
                    continue;
                }
                ArrayList<Integer> priorityList = new ArrayList<Integer>();
                priorityList.add(i);
                priorityMap.put(priority, priorityList);
            }
        }
        if (downgradeMap.isEmpty()) {
            return;
        }
        HashMap<LivingUpgrade, Integer> pointDifferentialMap = new HashMap<LivingUpgrade, Integer>();
        int totalDifferentialPoints = 0;
        for (Map.Entry entry : downgradeMap.entrySet()) {
            int totalRequiredPoints;
            int upgradeRequiredPoints;
            int wantedLevel;
            LivingUpgrade downgrade = (LivingUpgrade)((Object)entry.getKey());
            int playerDowngradeLevel = playerStats.getLevel(downgrade.getKey());
            if (playerDowngradeLevel >= (wantedLevel = Math.min((Integer)entry.getValue(), downgrade.getLevel(Integer.MAX_VALUE)))) continue;
            int playerInitialPoints = 0;
            if (playerDowngradeLevel > 0) {
                playerInitialPoints = playerStats.getUpgrades().getOrDefault((Object)downgrade, 0.0).intValue();
            }
            if ((upgradeRequiredPoints = (totalRequiredPoints = Math.abs(downgrade.getLevelCost(wantedLevel))) - playerInitialPoints) <= 0) continue;
            pointDifferentialMap.put(downgrade, upgradeRequiredPoints);
            totalDifferentialPoints += upgradeRequiredPoints;
        }
        if (availablePoints < totalDifferentialPoints || priorityMap.isEmpty() || pointDifferentialMap.isEmpty()) {
            return;
        }
        ArrayList slotOrderList = new ArrayList();
        ArrayList priorityList = new ArrayList(priorityMap.keySet());
        Collections.sort(priorityList);
        Iterator downgrade = priorityList.iterator();
        while (downgrade.hasNext()) {
            int priority = (Integer)downgrade.next();
            slotOrderList.addAll((Collection)priorityMap.get(priority));
        }
        int initialRequiredPoints = requiredPoints = totalDifferentialPoints;
        ArrayList<ItemStack> excessStackList = new ArrayList<ItemStack>();
        if (capability.isPresent()) {
            IItemHandler handler = (IItemHandler)capability.resolve().get();
            Iterator totalRequiredPoints = slotOrderList.iterator();
            while (totalRequiredPoints.hasNext()) {
                int i = (Integer)totalRequiredPoints.next();
                ItemStack invStack = handler.getStackInSlot(i);
                if (invStack.func_190926_b() || !(invStack.func_77973_b() instanceof ILivingUpgradePointsProvider)) continue;
                ItemStack simStack = handler.extractItem(i, invStack.func_190916_E(), true);
                int containedPoints = ((ILivingUpgradePointsProvider)simStack.func_77973_b()).getAvailableUpgradePoints(simStack, requiredPoints);
                int drainPoints = Math.min(containedPoints, requiredPoints);
                int remainingPointsInItem = ((ILivingUpgradePointsProvider)simStack.func_77973_b()).getExcessUpgradePoints(simStack, drainPoints);
                ItemStack newItemStack = ((ILivingUpgradePointsProvider)simStack.func_77973_b()).getResultingStack(simStack, drainPoints);
                if (!newItemStack.func_190926_b() && !handler.isItemValid(i, newItemStack)) continue;
                int totalPoints = ((ILivingUpgradePointsProvider)simStack.func_77973_b()).getTotalUpgradePoints(simStack);
                int totalDrainedPoints = totalPoints - remainingPointsInItem;
                requiredPoints -= totalDrainedPoints;
                handler.extractItem(i, simStack.func_190916_E(), false);
                ItemStack remainingStack = handler.insertItem(i, newItemStack, false);
                if (!remainingStack.func_190926_b()) {
                    excessStackList.add(remainingStack);
                }
                if (requiredPoints > 0) continue;
                break;
            }
        } else if (tile instanceof IInventory) {
            Iterator handler = slotOrderList.iterator();
            while (handler.hasNext()) {
                int i = (Integer)handler.next();
                ItemStack invStack = ((IInventory)tile).func_70301_a(i);
                if (invStack.func_190926_b() || !(invStack.func_77973_b() instanceof ILivingUpgradePointsProvider)) continue;
                int drainPoints = Math.min(((ILivingUpgradePointsProvider)invStack.func_77973_b()).getAvailableUpgradePoints(invStack, requiredPoints), requiredPoints);
                int remainingPointsInItem = ((ILivingUpgradePointsProvider)invStack.func_77973_b()).getExcessUpgradePoints(invStack, drainPoints);
                ItemStack newItemStack = ((ILivingUpgradePointsProvider)invStack.func_77973_b()).getResultingStack(invStack, drainPoints);
                ((IInventory)tile).func_70299_a(i, newItemStack);
                if ((requiredPoints -= drainPoints - remainingPointsInItem) > 0) continue;
                break;
            }
        }
        if (requiredPoints < 0) {
            ItemStack scrapStack = new ItemStack((IItemProvider)BloodMagicItems.UPGRADE_SCRAPS.get());
            ((ItemLivingTomeScrap)BloodMagicItems.UPGRADE_SCRAPS.get()).setTotalUpgradePoints(scrapStack, Math.abs(requiredPoints));
            excessStackList.add(scrapStack);
        }
        if (requiredPoints <= 0) {
            for (Map.Entry entry : pointDifferentialMap.entrySet()) {
                LivingUtil.applyExperienceToUpgradeCap(selectedPlayer, (LivingUpgrade)((Object)entry.getKey()), ((Integer)entry.getValue()).intValue());
            }
            masterRitualStone.setActive(false);
            LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            lightningboltentity.func_70107_b((double)masterPos.func_177958_n() + 0.5, (double)masterPos.func_177956_o(), (double)masterPos.func_177952_p() + 0.5);
            world.func_217376_c((Entity)lightningboltentity);
        } else if (requiredPoints < initialRequiredPoints) {
            ItemStack scrapStack = new ItemStack((IItemProvider)BloodMagicItems.UPGRADE_SCRAPS.get());
            ((ItemLivingTomeScrap)BloodMagicItems.UPGRADE_SCRAPS.get()).setTotalUpgradePoints(scrapStack, Math.abs(initialRequiredPoints - requiredPoints));
            excessStackList.add(scrapStack);
        }
        for (ItemStack item : excessStackList) {
            ItemStack copyStack = item.func_77946_l();
            if (tile == null) {
                Utils.spawnStackAtBlock(world, chestPos, Direction.UP, copyStack);
                continue;
            }
            copyStack = Utils.insertStackIntoTile(copyStack, tile, Direction.DOWN);
            if (copyStack.func_190926_b()) continue;
            Utils.spawnStackAtBlock(world, chestPos, Direction.UP, copyStack);
        }
    }

    public int getAvailablePointsFromStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof ILivingUpgradePointsProvider) {
            return ((ILivingUpgradePointsProvider)stack.func_77973_b()).getTotalUpgradePoints(stack);
        }
        return 0;
    }

    public int getPriorityFromStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        if (stack.func_77973_b() instanceof ILivingUpgradePointsProvider) {
            return ((ILivingUpgradePointsProvider)stack.func_77973_b()).getPriority(stack);
        }
        return 0;
    }

    public int getLevelFromStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (!(stack.func_77973_b() instanceof ILivingUpgradePointsProvider)) {
            return stack.func_190916_E();
        }
        return 0;
    }

    public LivingUpgrade getDowngradeFromStack(World world, ItemStack focusStack) {
        RecipeLivingDowngrade downgradeRecipe;
        if (focusStack.func_190926_b()) {
            return LivingUpgrade.DUMMY;
        }
        if (!(focusStack.func_77973_b() instanceof ILivingUpgradePointsProvider) && (downgradeRecipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getLivingDowngrade(world, focusStack)) != null) {
            return LivingArmorRegistrar.UPGRADE_MAP.getOrDefault(downgradeRecipe.getLivingArmourResource(), LivingUpgrade.DUMMY);
        }
        return LivingUpgrade.DUMMY;
    }

    public ItemStack getStackFromItemFrame(World world, BlockPos masterPos, Direction direction) {
        BlockPos offsetPos = new BlockPos(0, 3, 0);
        offsetPos = offsetPos.func_177967_a(direction, 2);
        AxisAlignedBB bb = new AxisAlignedBB(masterPos.func_177971_a((Vector3i)offsetPos));
        List frames = world.func_217357_a(ItemFrameEntity.class, bb);
        for (ItemFrameEntity frame : frames) {
            if (frame.func_82335_i().func_190926_b()) continue;
            return frame.func_82335_i();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, 0, -1, EnumRuneType.AIR);
        this.addRune(components, 0, 0, -2, EnumRuneType.DUSK);
        this.addRune(components, 0, 1, -3, EnumRuneType.DUSK);
        this.addRune(components, 0, 2, -3, EnumRuneType.BLANK);
        this.addRune(components, 0, 3, -3, EnumRuneType.BLANK);
        this.addRune(components, 0, 1, -4, EnumRuneType.FIRE);
        for (int i = 1; i <= 3; ++i) {
            this.addRune(components, 0, 0, i, EnumRuneType.AIR);
        }
        for (int sgn = -1; sgn <= 1; sgn += 2) {
            this.addRune(components, sgn, 0, 4, EnumRuneType.AIR);
            this.addRune(components, sgn * 2, 0, 2, EnumRuneType.AIR);
            this.addRune(components, sgn * 3, 0, 2, EnumRuneType.AIR);
            this.addRune(components, sgn * 3, 0, 3, EnumRuneType.AIR);
            this.addRune(components, sgn, 0, 0, EnumRuneType.EARTH);
            this.addRune(components, sgn, 0, 1, EnumRuneType.EARTH);
            this.addRune(components, sgn * 2, 0, -1, EnumRuneType.FIRE);
            this.addRune(components, sgn * 2, 0, -2, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -2, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -3, EnumRuneType.FIRE);
            this.addRune(components, sgn * 3, 0, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn, 1, -1, EnumRuneType.AIR);
            this.addRune(components, sgn, 1, -2, EnumRuneType.AIR);
            this.addRune(components, sgn, 1, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn * 2, 1, -4, EnumRuneType.FIRE);
            this.addRune(components, sgn, 0, -3, EnumRuneType.EARTH);
            this.addRune(components, sgn, 0, -4, EnumRuneType.EARTH);
            this.addRune(components, sgn, 0, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn, 1, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn, 2, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn, 3, -5, EnumRuneType.EARTH);
            this.addRune(components, sgn, 3, -4, EnumRuneType.EARTH);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualLivingDowngrade();
    }
}

