/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.structures.DungeonRoom;

public class DungeonRoomRegistry {
    public static Map<DungeonRoom, Integer> dungeonWeightMap = new HashMap<DungeonRoom, Integer>();
    public static Map<String, List<DungeonRoom>> dungeonStartingRoomMap = new HashMap<String, List<DungeonRoom>>();
    private static int totalWeight = 0;
    public static Map<ResourceLocation, DungeonRoom> dungeonRoomMap = new HashMap<ResourceLocation, DungeonRoom>();
    public static Map<ResourceLocation, List<Pair<ResourceLocation, Integer>>> roomPoolTable = new HashMap<ResourceLocation, List<Pair<ResourceLocation, Integer>>>();
    private static Map<ResourceLocation, Integer> totalWeightMap = new HashMap<ResourceLocation, Integer>();

    public static void registerDungeonRoom(ResourceLocation res, DungeonRoom room, int weight) {
        dungeonWeightMap.put(room, weight);
        totalWeight += weight;
        dungeonRoomMap.put(res, room);
    }

    public static void registerDungeomRoomPool(ResourceLocation poolRes, List<Pair<ResourceLocation, Integer>> pool) {
        roomPoolTable.put(poolRes, pool);
        int totalWeightOfPool = 0;
        for (Pair<ResourceLocation, Integer> room : pool) {
            totalWeightOfPool += ((Integer)room.getValue()).intValue();
        }
        totalWeightMap.put(poolRes, totalWeightOfPool);
    }

    public static DungeonRoom getRandomDungeonRoom(ResourceLocation roomPoolName, Random rand) {
        List<Pair<ResourceLocation, Integer>> roomPool;
        Integer maxWeight = totalWeightMap.get(roomPoolName);
        int wantedWeight = 0;
        if (maxWeight != null) {
            wantedWeight = rand.nextInt(maxWeight);
        }
        if ((roomPool = roomPoolTable.get(roomPoolName)) == null) {
            return null;
        }
        for (Pair<ResourceLocation, Integer> entry : roomPool) {
            if (wantedWeight <= 0) {
                ResourceLocation dungeonName = (ResourceLocation)entry.getKey();
                return dungeonRoomMap.get(dungeonName);
            }
            wantedWeight -= ((Integer)entry.getValue()).intValue();
        }
        return null;
    }

    public static void registerStarterDungeonRoom(DungeonRoom room, String key) {
        if (dungeonStartingRoomMap.containsKey(key)) {
            dungeonStartingRoomMap.get(key).add(room);
        } else {
            ArrayList<DungeonRoom> roomList = new ArrayList<DungeonRoom>();
            roomList.add(room);
            dungeonStartingRoomMap.put(key, roomList);
        }
    }

    public static DungeonRoom getRandomDungeonRoom(Random rand) {
        int wantedWeight = rand.nextInt(totalWeight);
        for (Map.Entry<DungeonRoom, Integer> entry : dungeonWeightMap.entrySet()) {
            if ((wantedWeight -= entry.getValue().intValue()) >= 0) continue;
            return entry.getKey();
        }
        return null;
    }

    public static DungeonRoom getRandomStarterDungeonRoom(Random rand, String key) {
        if (dungeonStartingRoomMap.containsKey(key)) {
            List<DungeonRoom> roomList = dungeonStartingRoomMap.get(key);
            return roomList.get(rand.nextInt(roomList.size()));
        }
        return null;
    }
}

