/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWillConduit;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.tile.TileDemonCrystal;
import wayoftime.bloodmagic.tile.base.TileTicking;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class TileDemonCrystallizer
extends TileTicking
implements IDemonWillConduit {
    @ObjectHolder(value="bloodmagic:demoncrystallizer")
    public static TileEntityType<TileDemonCrystallizer> TYPE;
    public static final int maxWill = 100;
    public static final double drainRate = 1.0;
    public static final double willToFormCrystal = 99.0;
    public static final double totalFormationTime = 1000.0;
    public DemonWillHolder holder = new DemonWillHolder();
    public double internalCounter = 0.0;

    public TileDemonCrystallizer(TileEntityType<?> type) {
        super(type);
    }

    public TileDemonCrystallizer() {
        this(TYPE);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos offsetPos = this.field_174879_c.func_177972_a(Direction.UP);
        if (this.func_145831_w().func_175623_d(offsetPos)) {
            EnumDemonWillType highestType = WorldDemonWillHandler.getHighestDemonWillType(this.func_145831_w(), this.field_174879_c);
            double amount = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, highestType);
            if (amount >= 99.0) {
                this.internalCounter += this.getCrystalFormationRate(amount);
                if (this.internalCounter >= 1000.0 && WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), highestType, 99.0, false) >= 99.0 && this.formCrystal(highestType, offsetPos)) {
                    WorldDemonWillHandler.drainWill(this.func_145831_w(), this.func_174877_v(), highestType, 99.0, true);
                    this.internalCounter = 0.0;
                }
            }
        }
    }

    public boolean formCrystal(EnumDemonWillType type, BlockPos position) {
        Block block = (Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get();
        switch (type) {
            case CORROSIVE: {
                block = (Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get();
                break;
            }
            case DESTRUCTIVE: {
                block = (Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get();
                break;
            }
            case STEADFAST: {
                block = (Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get();
                break;
            }
            case VENGEFUL: {
                block = (Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get();
                break;
            }
        }
        this.func_145831_w().func_175656_a(position, block.func_176223_P());
        TileEntity tile = this.func_145831_w().func_175625_s(position);
        if (tile instanceof TileDemonCrystal) {
            ((TileDemonCrystal)tile).setPlacement(Direction.UP);
            return true;
        }
        return false;
    }

    public double getCrystalFormationRate(double currentWill) {
        return 1.0;
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        this.holder.readFromNBT(tag, "Will");
        this.internalCounter = tag.func_74769_h("internalCounter");
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        this.holder.writeToNBT(tag, "Will");
        tag.func_74780_a("internalCounter", this.internalCounter);
        return tag;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        if (!doFill) {
            return Math.min(100.0 - this.holder.getWill(type), amount);
        }
        return this.holder.addWill(type, amount, 100.0);
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        double drained = amount;
        double current = this.holder.getWill(type);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            return this.holder.drainWill(type, amount);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return this.holder.getWill(type);
    }
}

