/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.network.PacketDistributor;
import twilightforest.TFConfig;
import twilightforest.TFMagicMapData;
import twilightforest.entity.TFPartEntity;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateTFMultipartPacket;
import twilightforest.world.TFDimensions;

public class ASMHooks {
    public static volatile World world;
    private static final WeakHashMap<World, List<TFPartEntity<?>>> cache;

    public static long seed(long seed) {
        TFDimensions.seed = seed;
        return seed;
    }

    public static void mapRenderContext(MatrixStack stack, IRenderTypeBuffer buffer, int light) {
        TFMagicMapData.TFMapDecoration.RenderContext.stack = stack;
        TFMagicMapData.TFMapDecoration.RenderContext.buffer = buffer;
        TFMagicMapData.TFMapDecoration.RenderContext.light = light;
    }

    public static BackgroundMusicSelector music(BackgroundMusicSelector music) {
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null && (music == BackgroundMusicTracks.field_232671_b_ || music == BackgroundMusicTracks.field_232675_f_) && Minecraft.func_71410_x().field_71441_e.func_234923_W_().func_240901_a_().toString().equals(TFConfig.COMMON_CONFIG.DIMENSION.twilightForestID.get())) {
            return Minecraft.func_71410_x().field_71441_e.func_225523_d_().func_235201_b_(Minecraft.func_71410_x().field_71439_g.func_233580_cy_()).func_235094_x_().orElse(BackgroundMusicTracks.field_232676_g_);
        }
        return music;
    }

    public static void registerMultipartEvents(IEventBus bus) {
        bus.addListener(event -> {
            if (event.getEntity().isMultipartEntity()) {
                WeakHashMap<World, List<TFPartEntity<?>>> weakHashMap = cache;
                synchronized (weakHashMap) {
                    cache.computeIfAbsent(event.getWorld(), w -> new ArrayList());
                    cache.get(event.getWorld()).addAll(Arrays.stream((Object[])Objects.requireNonNull(event.getEntity().getParts())).filter(TFPartEntity.class::isInstance).map(obj -> (TFPartEntity)((Object)((Object)obj))).collect(Collectors.toList()));
                }
            }
        });
        bus.addListener(event -> {
            if (event.getEntity().isMultipartEntity()) {
                WeakHashMap<World, List<TFPartEntity<?>>> weakHashMap = cache;
                synchronized (weakHashMap) {
                    cache.computeIfPresent(event.getWorld(), (world, list) -> {
                        list.removeAll(Arrays.stream((Object[])Objects.requireNonNull(event.getEntity().getParts())).filter(TFPartEntity.class::isInstance).map(TFPartEntity.class::cast).collect(Collectors.toList()));
                        return list;
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<Entity> multipartHitbox(List<Entity> list, World world, @Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        WeakHashMap<World, List<TFPartEntity<?>>> weakHashMap = cache;
        synchronized (weakHashMap) {
            List<TFPartEntity<?>> parts = cache.get(world);
            if (parts != null) {
                for (TFPartEntity<?> part : parts) {
                    if (part == entityIn || !part.func_174813_aQ().func_72326_a(boundingBox) || predicate != null && !predicate.test((Entity)part) || list.contains(part)) continue;
                    list.add((Entity)part);
                }
            }
            return list;
        }
    }

    public static Entity updateMultiparts(Entity entity) {
        if (entity.isMultipartEntity()) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new UpdateTFMultipartPacket(entity));
        }
        return entity;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static EntityRenderer<?> getMultipartRenderer(@Nullable EntityRenderer<?> renderer, Entity entity, EntityRendererManager manager) {
        if (entity instanceof TFPartEntity) {
            return ((TFPartEntity)entity).renderer(manager);
        }
        return renderer;
    }

    public static Iterable<Entity> renderMutiparts(Iterable<Entity> iter) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        iter.forEach(entity -> {
            list.add((Entity)entity);
            if (entity.isMultipartEntity() && entity.getParts() != null) {
                for (PartEntity part : entity.getParts()) {
                    if (!(part instanceof TFPartEntity)) continue;
                    list.add((Entity)part);
                }
            }
        });
        return list;
    }

    static {
        cache = new WeakHashMap();
    }
}

