/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;

public class TFMagicMapData
extends MapData {
    private static final Map<World, Map<String, TFMagicMapData>> CLIENT_DATA = new WeakHashMap<World, Map<String, TFMagicMapData>>();
    public final Set<TFMapDecoration> tfDecorations = new HashSet<TFMapDecoration>();

    public TFMagicMapData(String name) {
        super(name);
    }

    public void func_76184_a(CompoundNBT cmp) {
        super.func_76184_a(cmp);
        byte[] featureStorage = cmp.func_74770_j("features");
        if (featureStorage.length > 0) {
            this.deserializeFeatures(featureStorage);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT cmp) {
        cmp = super.func_189551_b(cmp);
        if (this.tfDecorations.size() > 0) {
            cmp.func_74773_a("features", this.serializeFeatures());
        }
        return cmp;
    }

    public void checkExistingFeatures(World world) {
        ArrayList<TFMapDecoration> toRemove = new ArrayList<TFMapDecoration>();
        ArrayList<TFMapDecoration> toAdd = new ArrayList<TFMapDecoration>();
        for (TFMapDecoration coord : this.tfDecorations) {
            int worldZ;
            int worldX = (coord.func_176112_b() << this.field_76197_d - 1) + this.field_76201_a;
            int trueId = TFFeature.getFeatureID(worldX, worldZ = (coord.func_176113_c() << this.field_76197_d - 1) + this.field_76199_b, (ISeedReader)((ServerWorld)world));
            if (coord.featureId == trueId) continue;
            toRemove.add(coord);
            toAdd.add(new TFMapDecoration(trueId, coord.func_176112_b(), coord.func_176113_c(), coord.func_176111_d()));
        }
        toRemove.forEach(this.tfDecorations::remove);
        this.tfDecorations.addAll(toAdd);
    }

    public void deserializeFeatures(byte[] arr) {
        this.tfDecorations.clear();
        for (int i = 0; i < arr.length / 3; ++i) {
            byte featureId = arr[i * 3];
            byte mapX = arr[i * 3 + 1];
            byte mapZ = arr[i * 3 + 2];
            byte mapRotation = 8;
            this.tfDecorations.add(new TFMapDecoration(featureId, mapX, mapZ, mapRotation));
        }
    }

    public byte[] serializeFeatures() {
        byte[] storage = new byte[this.tfDecorations.size() * 3];
        int i = 0;
        for (TFMapDecoration featureCoord : this.tfDecorations) {
            storage[i * 3] = (byte)featureCoord.featureId;
            storage[i * 3 + 1] = featureCoord.func_176112_b();
            storage[i * 3 + 2] = featureCoord.func_176113_c();
            ++i;
        }
        return storage;
    }

    public void func_176054_a(double x, double z, int mapScale) {
        int mapSize = 128 * (1 << mapScale);
        int roundX = (int)Math.round(x / (double)mapSize);
        int roundZ = (int)Math.round(z / (double)mapSize);
        this.field_76201_a = roundX * mapSize;
        this.field_76199_b = roundZ * mapSize;
    }

    @Nullable
    public static TFMagicMapData getMagicMapData(World world, String name) {
        if (world.field_72995_K) {
            return (TFMagicMapData)((Object)CLIENT_DATA.getOrDefault(world, Collections.emptyMap()).get(name));
        }
        return (TFMagicMapData)world.func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215753_b(() -> new TFMagicMapData(name), name);
    }

    public static void registerMagicMapData(World world, TFMagicMapData data) {
        if (world.field_72995_K) {
            CLIENT_DATA.computeIfAbsent(world, k -> new HashMap()).put(data.func_195925_e(), data);
        } else {
            world.func_73046_m().func_71218_a(World.field_234918_g_).func_217481_x().func_215757_a((WorldSavedData)data);
        }
    }

    public static class TFMapDecoration
    extends MapDecoration {
        final int featureId;

        public TFMapDecoration(int featureId, byte xIn, byte yIn, byte rotationIn) {
            super(MapDecoration.Type.TARGET_X, xIn, yIn, rotationIn, (ITextComponent)new TranslationTextComponent("map.magic.text"));
            this.featureId = featureId;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean render(int idx) {
            if (TFFeature.getFeatureByID((int)this.featureId).isStructureEnabled) {
                RenderContext.stack.func_227860_a_();
                RenderContext.stack.func_227861_a_((double)(0.0f + (float)this.func_176112_b() / 2.0f + 64.0f), (double)(0.0f + (float)this.func_176113_c() / 2.0f + 64.0f), (double)-0.02f);
                RenderContext.stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(this.func_176111_d() * 360) / 16.0f));
                RenderContext.stack.func_227862_a_(4.0f, 4.0f, 3.0f);
                RenderContext.stack.func_227861_a_(-0.125, 0.125, 0.0);
                float f1 = (float)(this.featureId % 8) / 8.0f;
                float f2 = (float)(this.featureId / 8) / 8.0f;
                float f3 = (float)(this.featureId % 8 + 1) / 8.0f;
                float f4 = (float)(this.featureId / 8 + 1) / 8.0f;
                Matrix4f matrix4f1 = RenderContext.stack.func_227866_c_().func_227870_a_();
                IVertexBuilder ivertexbuilder1 = RenderContext.buffer.getBuffer(RenderContext.MAP_ICONS);
                ivertexbuilder1.func_227888_a_(matrix4f1, -1.0f, 1.0f, (float)idx * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(f1, f2).func_227886_a_(RenderContext.light).func_181675_d();
                ivertexbuilder1.func_227888_a_(matrix4f1, 1.0f, 1.0f, (float)idx * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(f3, f2).func_227886_a_(RenderContext.light).func_181675_d();
                ivertexbuilder1.func_227888_a_(matrix4f1, 1.0f, -1.0f, (float)idx * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(f3, f4).func_227886_a_(RenderContext.light).func_181675_d();
                ivertexbuilder1.func_227888_a_(matrix4f1, -1.0f, -1.0f, (float)idx * -0.001f).func_225586_a_(255, 255, 255, 255).func_225583_a_(f1, f4).func_227886_a_(RenderContext.light).func_181675_d();
                RenderContext.stack.func_227865_b_();
            }
            return true;
        }

        public boolean equals(Object o) {
            if (super.equals(o) && o instanceof TFMapDecoration) {
                TFMapDecoration other = (TFMapDecoration)((Object)o);
                return this.featureId == other.featureId;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() * 31 + this.featureId;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class RenderContext {
            private static final RenderType MAP_ICONS = RenderType.func_228658_l_((ResourceLocation)TwilightForestMod.prefix("textures/gui/mapicons.png"));
            public static MatrixStack stack;
            public static IRenderTypeBuffer buffer;
            public static int light;
        }
    }
}

