/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.structures.courtyard.NagaCourtyardPieces;
import twilightforest.structures.darktower.DarkTowerPieces;
import twilightforest.structures.finalcastle.FinalCastlePieces;
import twilightforest.structures.icetower.IceTowerPieces;
import twilightforest.structures.lichtower.LichTowerPieces;
import twilightforest.structures.minotaurmaze.MinotaurMazePieces;
import twilightforest.structures.mushroomtower.MushroomTowerPieces;
import twilightforest.structures.start.TFStructure;
import twilightforest.structures.stronghold.StrongholdPieces;
import twilightforest.structures.trollcave.TrollCavePieces;
import twilightforest.world.ChunkGeneratorTwilightBase;

public class TFStructures {
    public static final Map<Structure<?>, StructureSeparationSettings> SEPARATION_SETTINGS = new HashMap();
    public static final Structure<NoFeatureConfig> HEDGE_MAZE = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.HEDGE_MAZE);
    public static final StructureFeature<?, ?> CONFIGURED_HEDGE_MAZE = HEDGE_MAZE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> QUEST_GROVE = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.QUEST_GROVE);
    public static final StructureFeature<?, ?> CONFIGURED_QUEST_GROVE = QUEST_GROVE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> MUSHROOM_TOWER = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.MUSHROOM_TOWER);
    public static final StructureFeature<?, ?> CONFIGURED_MUSHROOM_TOWER = MUSHROOM_TOWER.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> HOLLOW_HILL_SMALL = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.SMALL_HILL);
    public static final StructureFeature<?, ?> CONFIGURED_HOLLOW_HILL_SMALL = HOLLOW_HILL_SMALL.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> HOLLOW_HILL_MEDIUM = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.MEDIUM_HILL);
    public static final StructureFeature<?, ?> CONFIGURED_HOLLOW_HILL_MEDIUM = HOLLOW_HILL_MEDIUM.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> HOLLOW_HILL_LARGE = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.LARGE_HILL);
    public static final StructureFeature<?, ?> CONFIGURED_HOLLOW_HILL_LARGE = HOLLOW_HILL_LARGE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> NAGA_COURTYARD = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.NAGA_COURTYARD, true);
    public static final StructureFeature<?, ?> CONFIGURED_NAGA_COURTYARD = NAGA_COURTYARD.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> LICH_TOWER = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.LICH_TOWER);
    public static final StructureFeature<?, ?> CONFIGURED_LICH_TOWER = LICH_TOWER.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> LABYRINTH = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.LABYRINTH);
    public static final StructureFeature<?, ?> CONFIGURED_LABYRINTH = LABYRINTH.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> HYDRA_LAIR = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.HYDRA_LAIR);
    public static final StructureFeature<?, ?> CONFIGURED_HYDRA_LAIR = HYDRA_LAIR.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> KNIGHT_STRONGHOLD = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.KNIGHT_STRONGHOLD);
    public static final StructureFeature<?, ?> CONFIGURED_KNIGHT_STRONGHOLD = KNIGHT_STRONGHOLD.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> DARK_TOWER = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.DARK_TOWER);
    public static final StructureFeature<?, ?> CONFIGURED_DARK_TOWER = DARK_TOWER.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> YETI_CAVE = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.YETI_CAVE);
    public static final StructureFeature<?, ?> CONFIGURED_YETI_CAVE = YETI_CAVE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> AURORA_PALACE = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.ICE_TOWER);
    public static final StructureFeature<?, ?> CONFIGURED_AURORA_PALACE = AURORA_PALACE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> TROLL_CAVE = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.TROLL_CAVE);
    public static final StructureFeature<?, ?> CONFIGURED_TROLL_CAVE = TROLL_CAVE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);
    public static final Structure<NoFeatureConfig> FINAL_CASTLE = new TFStructure<NoFeatureConfig>(NoFeatureConfig.field_236558_a_, TFFeature.FINAL_CASTLE);
    public static final StructureFeature<?, ?> CONFIGURED_FINAL_CASTLE = FINAL_CASTLE.func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e);

    public static void register(RegistryEvent.Register<Structure<?>> event) {
        SEPARATION_SETTINGS.clear();
        TFFeature.init();
        new MushroomTowerPieces();
        new NagaCourtyardPieces();
        new LichTowerPieces();
        new MinotaurMazePieces();
        new StrongholdPieces();
        new DarkTowerPieces();
        new IceTowerPieces();
        new TrollCavePieces();
        new FinalCastlePieces();
        TFStructures.register(event, HEDGE_MAZE, CONFIGURED_HEDGE_MAZE, TwilightForestMod.prefix("hedgemaze"), 1, 2);
        TFStructures.register(event, QUEST_GROVE, CONFIGURED_QUEST_GROVE, TwilightForestMod.prefix("questgrove"), 1, 2);
        TFStructures.register(event, MUSHROOM_TOWER, CONFIGURED_MUSHROOM_TOWER, TwilightForestMod.prefix("mushroomtower"), 1, 2);
        TFStructures.register(event, HOLLOW_HILL_SMALL, CONFIGURED_HOLLOW_HILL_SMALL, TwilightForestMod.prefix("hollowhillsmall"), 1, 2);
        TFStructures.register(event, HOLLOW_HILL_MEDIUM, CONFIGURED_HOLLOW_HILL_MEDIUM, TwilightForestMod.prefix("hollowhillmedium"), 1, 2);
        TFStructures.register(event, HOLLOW_HILL_LARGE, CONFIGURED_HOLLOW_HILL_LARGE, TwilightForestMod.prefix("hollowhilllarge"), 1, 2);
        TFStructures.register(event, NAGA_COURTYARD, CONFIGURED_NAGA_COURTYARD, TwilightForestMod.prefix("courtyard"), 1, 2);
        TFStructures.register(event, LICH_TOWER, CONFIGURED_LICH_TOWER, TwilightForestMod.prefix("lichtower"), 1, 2);
        TFStructures.register(event, LABYRINTH, CONFIGURED_LABYRINTH, TwilightForestMod.prefix("labyrinth"), 1, 2);
        TFStructures.register(event, HYDRA_LAIR, CONFIGURED_HYDRA_LAIR, TwilightForestMod.prefix("hydralair"), 1, 2);
        TFStructures.register(event, KNIGHT_STRONGHOLD, CONFIGURED_KNIGHT_STRONGHOLD, TwilightForestMod.prefix("knightstronghold"), 1, 2);
        TFStructures.register(event, DARK_TOWER, CONFIGURED_DARK_TOWER, TwilightForestMod.prefix("darktower"), 1, 2);
        TFStructures.register(event, YETI_CAVE, CONFIGURED_YETI_CAVE, TwilightForestMod.prefix("yeticave"), 1, 2);
        TFStructures.register(event, AURORA_PALACE, CONFIGURED_AURORA_PALACE, TwilightForestMod.prefix("aurorapalace"), 1, 2);
        TFStructures.register(event, TROLL_CAVE, CONFIGURED_TROLL_CAVE, TwilightForestMod.prefix("trollcave"), 1, 2);
        TFStructures.register(event, FINAL_CASTLE, CONFIGURED_FINAL_CASTLE, TwilightForestMod.prefix("finalcastle"), 1, 2);
    }

    private static void register(RegistryEvent.Register<Structure<?>> event, Structure<?> structure, StructureFeature<?, ?> config, ResourceLocation name, int min, int max) {
        event.getRegistry().register(structure.setRegistryName(name));
        Structure.field_236365_a_.put((Object)name.toString(), structure);
        StructureSeparationSettings seperation = new StructureSeparationSettings(max, min, 472681346);
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)seperation).build();
        SEPARATION_SETTINGS.put(structure, seperation);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation(name.func_110624_b(), "configured_".concat(name.func_110623_a())), config);
        FlatGenerationSettings.field_202247_j.put(structure, config);
    }

    public static void load(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld && ((ServerWorld)event.getWorld()).func_72863_F().field_186029_c instanceof ChunkGeneratorTwilightBase) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.putAll(SEPARATION_SETTINGS);
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

