/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LargeFlameParticle
extends SpriteTexturedParticle {
    private final float flameScale;

    LargeFlameParticle(ClientWorld world, double x, double y, double z, double vx, double vy, double vz) {
        super(world, x, y, z, vx, vy, vz);
        this.field_187129_i = this.field_187129_i * (double)0.01f + vx;
        this.field_187130_j = this.field_187130_j * (double)0.01f + vy;
        this.field_187131_k = this.field_187131_k * (double)0.01f + vz;
        this.flameScale = this.field_70544_f = (float)((double)this.field_70544_f * 5.0);
        this.field_70551_j = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70552_h = 1.0f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.field_190017_n = false;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public float func_217561_b(float partialTicks) {
        float relativeAge = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        return this.flameScale * (1.0f - relativeAge * relativeAge * 0.5f);
    }

    public int func_189214_a(float partialTicks) {
        float var2 = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        if (var2 < 0.0f) {
            var2 = 0.0f;
        }
        if (var2 > 1.0f) {
            var2 = 1.0f;
        }
        int var3 = super.func_189214_a(partialTicks);
        int var4 = var3 & 0xFF;
        int var5 = var3 >> 16 & 0xFF;
        if ((var4 += (int)(var2 * 15.0f * 16.0f)) > 240) {
            var4 = 240;
        }
        return var4 | var5 << 16;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j += 0.004;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)0.96f;
        this.field_187130_j *= (double)0.96f;
        this.field_187131_k *= (double)0.96f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LargeFlameParticle particle = new LargeFlameParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.func_217568_a(this.spriteSet);
            return particle;
        }
    }
}

