/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import twilightforest.client.particle.TFParticleType;

public class LeafParticleData
implements IParticleData {
    public final int r;
    public final int g;
    public final int b;

    public LeafParticleData(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Nonnull
    public ParticleType<?> func_197554_b() {
        return (ParticleType)TFParticleType.FALLEN_LEAF.get();
    }

    public static Codec<LeafParticleData> codecLeaf() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("r").forGetter(obj -> obj.r), (App)Codec.INT.fieldOf("g").forGetter(obj -> obj.g), (App)Codec.INT.fieldOf("b").forGetter(obj -> obj.b)).apply((Applicative)instance, LeafParticleData::new));
    }

    public void func_197553_a(@Nonnull PacketBuffer buf) {
        buf.func_150787_b(this.r);
        buf.func_150787_b(this.g);
        buf.func_150787_b(this.b);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format("%d %d %d", this.r, this.g, this.b);
    }

    public static class Deserializer
    implements IParticleData.IDeserializer<LeafParticleData> {
        @Nonnull
        public LeafParticleData deserialize(@Nonnull ParticleType<LeafParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.skipWhitespace();
            int r = reader.readInt();
            reader.skipWhitespace();
            int g = reader.readInt();
            reader.skipWhitespace();
            int b = reader.readInt();
            return new LeafParticleData(r, g, b);
        }

        @Nonnull
        public LeafParticleData read(@Nonnull ParticleType<LeafParticleData> type, PacketBuffer buf) {
            return new LeafParticleData(buf.func_150792_a(), buf.func_150792_a(), buf.func_150792_a());
        }
    }
}

