/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.BlockChainGoblinModel;
import twilightforest.client.model.entity.ChainModel;
import twilightforest.client.model.entity.SpikeBlockModel;
import twilightforest.client.renderer.entity.BlockChainRenderer;
import twilightforest.entity.BlockChainGoblinEntity;

public class BlockChainGoblinRenderer<T extends BlockChainGoblinEntity, M extends BlockChainGoblinModel<T>>
extends BipedRenderer<T, M> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("blockgoblin.png");
    private final Model model = new SpikeBlockModel();
    private final Model chainModel = new ChainModel();

    public BlockChainGoblinRenderer(EntityRendererManager manager, M model, float shadowSize) {
        super(manager, model, shadowSize);
    }

    public void render(T goblin, float yaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int light) {
        super.func_225623_a_(goblin, yaw, partialTicks, stack, buffer, light);
        stack.func_227860_a_();
        double blockInX = ((BlockChainGoblinEntity)((Object)goblin)).block.func_226277_ct_() - goblin.func_226277_ct_();
        double blockInY = ((BlockChainGoblinEntity)((Object)goblin)).block.func_226278_cu_() - goblin.func_226278_cu_();
        double blockInZ = ((BlockChainGoblinEntity)((Object)goblin)).block.func_226281_cx_() - goblin.func_226281_cx_();
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.model.func_228282_a_(textureLoc));
        stack.func_227861_a_(blockInX, blockInY, blockInZ);
        float pitch = ((BlockChainGoblinEntity)((Object)goblin)).field_70127_C + (((BlockChainGoblinEntity)((Object)goblin)).field_70125_A - ((BlockChainGoblinEntity)((Object)goblin)).field_70127_C) * partialTicks;
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - MathHelper.func_76142_g((float)yaw)));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.model.func_225598_a_(stack, ivertexbuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.func_227865_b_();
        BlockChainRenderer.renderChain(goblin, (Entity)((BlockChainGoblinEntity)((Object)goblin)).chain1, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain(goblin, (Entity)((BlockChainGoblinEntity)((Object)goblin)).chain2, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain(goblin, (Entity)((BlockChainGoblinEntity)((Object)goblin)).chain3, yaw, partialTicks, stack, buffer, light, this.chainModel);
        if (this.field_76990_c.func_178634_b() && !((BlockChainGoblinEntity)((Object)goblin)).block.func_82150_aj() && !Minecraft.func_71410_x().func_189648_am()) {
            stack.func_227860_a_();
            stack.func_227861_a_(blockInX, blockInY, blockInZ);
            this.renderMultiBoundingBox(stack, buffer.getBuffer(RenderType.func_228659_m_()), (Entity)((BlockChainGoblinEntity)((Object)goblin)).block, 0.25f, 1.0f, 0.0f);
            stack.func_227865_b_();
        }
    }

    private void renderMultiBoundingBox(MatrixStack stack, IVertexBuilder builder, Entity entity, float red, float grean, float blue) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(-entity.func_226277_ct_(), -entity.func_226278_cu_(), -entity.func_226281_cx_());
        WorldRenderer.func_228430_a_((MatrixStack)stack, (IVertexBuilder)builder, (AxisAlignedBB)axisalignedbb, (float)red, (float)grean, (float)blue, (float)1.0f);
    }

    public boolean shouldRender(T entity, ClippingHelper clippingHelper, double camX, double camY, double camZ) {
        if (super.func_225626_a_(entity, clippingHelper, camX, camY, camZ)) {
            return true;
        }
        Vector3d vec3d = this.getPosition((Entity)((BlockChainGoblinEntity)((Object)entity)).block, (double)((BlockChainGoblinEntity)((Object)entity)).block.func_213302_cg() * 0.5, 1.0f);
        Vector3d vec3d1 = this.getPosition((Entity)((BlockChainGoblinEntity)((Object)entity)).block, ((BlockChainGoblinEntity)((Object)entity)).block.func_70047_e(), 1.0f);
        return clippingHelper.func_228957_a_(new AxisAlignedBB(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c));
    }

    private Vector3d getPosition(Entity entity, double p_177110_2_, float p_177110_4_) {
        double d0 = MathHelper.func_219803_d((double)p_177110_4_, (double)entity.field_70142_S, (double)entity.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)p_177110_4_, (double)entity.field_70137_T, (double)entity.func_226278_cu_()) + p_177110_2_;
        double d2 = MathHelper.func_219803_d((double)p_177110_4_, (double)entity.field_70136_U, (double)entity.func_226281_cx_());
        return new Vector3d(d0, d1, d2);
    }

    public ResourceLocation getEntityTexture(T entity) {
        return textureLoc;
    }
}

