/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.entity.HydraNeckModel;
import twilightforest.client.renderer.entity.HydraHeadRenderer;
import twilightforest.client.renderer.entity.TFPartRenderer;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.entity.boss.HydraNeckEntity;

public class HydraNeckRenderer
extends TFPartRenderer<HydraNeckEntity, HydraNeckModel> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("hydra4.png");

    public HydraNeckRenderer(EntityRendererManager manager) {
        super(manager, new HydraNeckModel());
    }

    @Override
    public void render(HydraNeckEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int light) {
        HydraHeadContainer headCon = HydraHeadRenderer.getHeadObject(entityIn.head);
        if (headCon != null && headCon.shouldRenderHead()) {
            float yawDiff = entityIn.field_70177_z - entityIn.field_70126_B;
            if (yawDiff > 180.0f) {
                yawDiff -= 360.0f;
            } else if (yawDiff < -180.0f) {
                yawDiff += 360.0f;
            }
            float yaw2 = entityIn.field_70126_B + yawDiff * partialTicks;
            matrixStackIn.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(yaw2 + 180.0f));
            super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, light);
        }
    }

    public ResourceLocation getEntityTexture(HydraNeckEntity entity) {
        return textureLoc;
    }
}

