/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import twilightforest.entity.TFPartEntity;

public abstract class TFPartRenderer<T extends TFPartEntity<?>, M extends SegmentedModel<T>>
extends EntityRenderer<T> {
    protected final M entityModel;

    public TFPartRenderer(EntityRendererManager renderManager, M model) {
        super(renderManager);
        this.entityModel = model;
    }

    public void render(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int light) {
        int packedLightIn = this.field_76990_c.func_229085_a_(entityIn.getParent(), partialTicks);
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.func_227860_a_();
        float f = MathHelper.func_219805_h((float)partialTicks, (float)((TFPartEntity)((Object)entityIn)).prevRenderYawOffset, (float)((TFPartEntity)((Object)entityIn)).renderYawOffset);
        float f6 = MathHelper.func_219799_g((float)partialTicks, (float)((TFPartEntity)((Object)entityIn)).field_70127_C, (float)((TFPartEntity)((Object)entityIn)).field_70125_A);
        float f7 = this.handleRotationFloat(entityIn, partialTicks);
        this.applyRotations(entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        this.entityModel.func_212843_a_(entityIn, f5, f8, partialTicks);
        this.entityModel.func_225597_a_(entityIn, f5, f8, f7, f, f6);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean flag = this.isVisible(entityIn);
        boolean flag1 = !flag && !entityIn.func_98034_c((PlayerEntity)minecraft.field_71439_g);
        boolean flag2 = minecraft.func_238206_b_(entityIn);
        RenderType rendertype = this.getRenderType(entityIn, flag, flag1, flag2);
        if (rendertype != null) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(rendertype);
            int i = this.getPackedOverlay(entityIn, this.getOverlayProgress(entityIn, partialTicks));
            this.entityModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        matrixStackIn.func_227865_b_();
    }

    protected float getOverlayProgress(T livingEntityIn, float partialTicks) {
        return 0.0f;
    }

    public int getPackedOverlay(T livingEntityIn, float uIn) {
        if (livingEntityIn.getParent() instanceof LivingEntity) {
            return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)uIn), (int)OverlayTexture.func_229202_a_((((LivingEntity)livingEntityIn.getParent()).field_70737_aN > 0 || ((LivingEntity)livingEntityIn.getParent()).field_70725_aQ > 0 ? 1 : 0) != 0));
        }
        return OverlayTexture.field_229196_a_;
    }

    @Nullable
    protected RenderType getRenderType(T p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        ResourceLocation resourcelocation = this.func_110775_a((Entity)p_230496_1_);
        if (p_230496_3_) {
            return RenderType.func_239268_f_((ResourceLocation)resourcelocation);
        }
        if (p_230496_2_) {
            return this.entityModel.func_228282_a_(resourcelocation);
        }
        return p_230496_4_ ? RenderType.func_228654_j_((ResourceLocation)resourcelocation) : null;
    }

    protected float handleRotationFloat(T livingBase, float partialTicks) {
        return (float)((TFPartEntity)((Object)livingBase)).field_70173_aa + partialTicks;
    }

    protected void applyRotations(T entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (((TFPartEntity)((Object)entityLiving)).deathTime > 0) {
            float f = ((float)((TFPartEntity)((Object)entityLiving)).deathTime + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * this.getDeathMaxRotation(entityLiving)));
        }
    }

    protected float getDeathMaxRotation(T entityLivingBaseIn) {
        return 90.0f;
    }

    protected boolean isVisible(T livingEntityIn) {
        return !livingEntityIn.func_82150_aj();
    }
}

