/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.fml.RegistryObject;
import twilightforest.TwilightForestMod;
import twilightforest.data.ItemTagGenerator;

public abstract class CraftingDataHelper
extends RecipeProvider {
    public CraftingDataHelper(DataGenerator generator) {
        super(generator);
    }

    protected final Ingredient itemWithNBT(RegistryObject<? extends IItemProvider> item, Consumer<CompoundNBT> nbtSetter) {
        return this.itemWithNBT((IItemProvider)item.get(), nbtSetter);
    }

    protected final Ingredient itemWithNBT(IItemProvider item, Consumer<CompoundNBT> nbtSetter) {
        ItemStack stack = new ItemStack(item);
        CompoundNBT nbt = new CompoundNBT();
        nbtSetter.accept(nbt);
        stack.func_77982_d(nbt);
        try {
            Constructor constructor = NBTIngredient.class.getDeclaredConstructor(ItemStack.class);
            constructor.setAccessible(true);
            return (Ingredient)constructor.newInstance(stack);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
        }
    }

    protected final Ingredient multipleIngredients(Ingredient ... ingredientArray) {
        ImmutableList ingredientList = ImmutableList.copyOf((Object[])ingredientArray);
        try {
            Constructor constructor = CompoundIngredient.class.getDeclaredConstructor(List.class);
            constructor.setAccessible(true);
            return (Ingredient)constructor.newInstance(ingredientList);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return Ingredient.merge((Collection)ingredientList);
        }
    }

    protected final void charmRecipe(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, Supplier<? extends Item> item) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)result.get())).func_200491_b((IItemProvider)item.get(), 4).func_200483_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)item.get()))).func_200485_a(consumer, TwilightForestMod.prefix(name));
    }

    protected final void castleBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> criteria, IItemProvider ... ingredients) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)4).func_200472_a("##").func_200472_a("##").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])ingredients)).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)criteria.get()))).func_200467_a(consumer, this.locCastle(name));
    }

    protected final void stairsBlock(Consumer<IFinishedRecipe> consumer, ResourceLocation loc, Supplier<? extends Block> result, Supplier<? extends Block> criteria, IItemProvider ... ingredients) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)8).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])ingredients)).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)criteria.get()))).func_200467_a(consumer, loc);
    }

    protected final void stairsRightBlock(Consumer<IFinishedRecipe> consumer, ResourceLocation loc, Supplier<? extends Block> result, Supplier<? extends Block> criteria, IItemProvider ... ingredients) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)8).func_200472_a("###").func_200472_a(" ##").func_200472_a("  #").func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a((IItemProvider[])ingredients)).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)criteria.get()))).func_200467_a(consumer, loc);
    }

    protected final void reverseStairsBlock(Consumer<IFinishedRecipe> consumer, ResourceLocation loc, Supplier<? extends Block> result, Supplier<? extends Block> criteria, IItemProvider ingredient) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200487_b(ingredient).func_200487_b(ingredient).func_200487_b(ingredient).func_200487_b(ingredient).func_200483_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)criteria.get()))).func_200485_a(consumer, loc);
    }

    protected final void compressedBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, ITag.INamedTag<Item> ingredient) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200469_a(Character.valueOf('#'), ingredient).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(ingredient)).func_200467_a(consumer, TwilightForestMod.prefix("compressed_blocks/" + name));
    }

    protected final void reverseCompressBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, ITag.INamedTag<Item> ingredient) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)result.get()), (int)9).func_203221_a(ingredient).func_200483_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(ingredient)).func_200485_a(consumer, TwilightForestMod.prefix("compressed_blocks/reversed/" + name));
    }

    protected final void helmetItem(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, ITag.INamedTag<Item> material) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("###").func_200472_a("# #").func_200469_a(Character.valueOf('#'), material).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(material)).func_200467_a(consumer, this.locEquip(name));
    }

    protected final void chestplateItem(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, ITag.INamedTag<Item> material) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("# #").func_200472_a("###").func_200472_a("###").func_200469_a(Character.valueOf('#'), material).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(material)).func_200467_a(consumer, this.locEquip(name));
    }

    protected final void leggingsItem(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, ITag.INamedTag<Item> material) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("###").func_200472_a("# #").func_200472_a("# #").func_200469_a(Character.valueOf('#'), material).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(material)).func_200467_a(consumer, this.locEquip(name));
    }

    protected final void bootsItem(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, ITag.INamedTag<Item> material) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("# #").func_200472_a("# #").func_200469_a(Character.valueOf('#'), material).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(material)).func_200467_a(consumer, this.locEquip(name));
    }

    protected final void pickaxeItem(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, ITag.INamedTag<Item> material, ITag.INamedTag<Item> handle) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("###").func_200472_a(" X ").func_200472_a(" X ").func_200469_a(Character.valueOf('#'), material).func_200469_a(Character.valueOf('X'), handle).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(material)).func_200467_a(consumer, this.locEquip(name));
    }

    protected final void swordItem(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, ITag.INamedTag<Item> material, ITag.INamedTag<Item> handle) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("#").func_200472_a("#").func_200472_a("X").func_200469_a(Character.valueOf('#'), material).func_200469_a(Character.valueOf('X'), handle).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(material)).func_200467_a(consumer, this.locEquip(name));
    }

    protected final void axeItem(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Item> result, ITag.INamedTag<Item> material, ITag.INamedTag<Item> handle) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("##").func_200472_a("#X").func_200472_a(" X").func_200469_a(Character.valueOf('#'), material).func_200469_a(Character.valueOf('X'), handle).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(material)).func_200467_a(consumer, this.locEquip(name));
    }

    protected final void buttonBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)result.get())).func_200487_b((IItemProvider)material.get()).func_200483_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200485_a(consumer, this.locWood(name + "_button"));
    }

    protected final void doorBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_door"));
    }

    protected final void fenceBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("#S#").func_200472_a("#S#").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.RODS_WOODEN).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_fence"));
    }

    protected final void gateBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("S#S").func_200472_a("S#S").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.RODS_WOODEN).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_gate"));
    }

    protected final void planksBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)result.get()), (int)4).func_200487_b((IItemProvider)material.get()).func_200483_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200485_a(consumer, this.locWood(name + "_planks"));
    }

    protected final void plateBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)result.get())).func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_plate"));
    }

    protected final void slabBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_slab"));
    }

    protected final void trapdoorBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)6).func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_trapdoor"));
    }

    protected final void woodBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_wood"));
    }

    protected final void strippedWoodBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_stripped_wood"));
    }

    protected final void signBlock(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends Block> result, Supplier<? extends Block> material) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)result.get()), (int)3).func_200472_a("###").func_200472_a("###").func_200472_a(" - ").func_200462_a(Character.valueOf('#'), (IItemProvider)material.get()).func_200469_a(Character.valueOf('-'), (ITag)Tags.Items.RODS_WOODEN).func_200465_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200403_a((IItemProvider)((IItemProvider)material.get()))).func_200467_a(consumer, this.locWood(name + "_wood"));
    }

    protected final void fieryConversion(Consumer<IFinishedRecipe> consumer, Supplier<? extends Item> result, Item armor, int vials) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)result.get())).func_200487_b((IItemProvider)armor).func_200492_a(Ingredient.func_199805_a(ItemTagGenerator.FIERY_VIAL), vials).func_200483_a("has_item", (ICriterionInstance)CraftingDataHelper.func_200409_a(ItemTagGenerator.FIERY_VIAL)).func_200485_a(consumer, this.locEquip("fiery_" + armor.getRegistryName().func_110623_a()));
    }

    protected final ResourceLocation locCastle(String name) {
        return TwilightForestMod.prefix("castleblock/" + name);
    }

    protected final ResourceLocation locEquip(String name) {
        return TwilightForestMod.prefix("equipment/" + name);
    }

    protected final ResourceLocation locNaga(String name) {
        return TwilightForestMod.prefix("nagastone/" + name);
    }

    protected final ResourceLocation locWood(String name) {
        return TwilightForestMod.prefix("wood/" + name);
    }
}

