/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import twilightforest.TwilightForestMod;

public abstract class HoverBaseGoal<T extends MobEntity>
extends Goal {
    protected final T attacker;
    protected final float hoverHeight;
    protected final float hoverRadius;
    protected double hoverPosX;
    protected double hoverPosY;
    protected double hoverPosZ;

    protected HoverBaseGoal(T snowQueen, float hoverHeight, float hoverRadius) {
        this.attacker = snowQueen;
        this.hoverHeight = hoverHeight;
        this.hoverRadius = hoverRadius;
    }

    public void func_75249_e() {
        LivingEntity target = this.attacker.func_70638_az();
        if (target != null) {
            this.makeNewHoverSpot(target);
        }
    }

    protected void makeNewHoverSpot(LivingEntity target) {
        double hx = 0.0;
        double hy = 0.0;
        double hz = 0.0;
        boolean found = false;
        for (int i = 0; i < 100; ++i) {
            hx = target.func_226277_ct_() + (double)((this.attacker.func_70681_au().nextFloat() - this.attacker.func_70681_au().nextFloat()) * this.hoverRadius);
            if (this.isPositionOccupied(hx, hy = target.func_226278_cu_() + (double)this.hoverHeight, hz = target.func_226281_cx_() + (double)((this.attacker.func_70681_au().nextFloat() - this.attacker.func_70681_au().nextFloat()) * this.hoverRadius)) || !this.canEntitySee((Entity)this.attacker, hx, hy, hz) || !this.canEntitySee((Entity)target, hx, hy, hz)) continue;
            found = true;
            break;
        }
        if (!found) {
            TwilightForestMod.LOGGER.debug("Found no spots, giving up");
        }
        this.hoverPosX = hx;
        this.hoverPosY = hy;
        this.hoverPosZ = hz;
    }

    protected boolean isPositionOccupied(double hx, double hy, double hz) {
        float radius = this.attacker.func_213311_cf() / 2.0f;
        AxisAlignedBB aabb = new AxisAlignedBB(hx - (double)radius, hy, hz - (double)radius, hx + (double)radius, hy + (double)this.attacker.func_213302_cg(), hz + (double)radius);
        return !((MobEntity)this.attacker).field_70170_p.func_195585_a(this.attacker, VoxelShapes.func_197881_a((AxisAlignedBB)aabb)) || !((MobEntity)this.attacker).field_70170_p.func_226665_a__(this.attacker, aabb);
    }

    protected boolean canEntitySee(Entity entity, double dx, double dy, double dz) {
        return entity.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_()), new Vector3d(dx, dy, dz), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity)) == null;
    }
}

