/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import twilightforest.TFSounds;
import twilightforest.entity.ChainBlockEntity;
import twilightforest.entity.TFEntities;
import twilightforest.enums.TwilightItemTier;

public class ChainBlockItem
extends ToolItem {
    private static final String THROWN_UUID_KEY = "chainEntity";

    protected ChainBlockItem(Item.Properties props) {
        super(6.0f, -3.0f, (IItemTier)TwilightItemTier.TOOL_KNIGHTLY, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.field_150348_b}), props);
    }

    public void func_77663_a(ItemStack stack, World world, Entity holder, int slot, boolean isSelected) {
        if (!world.field_72995_K && ChainBlockItem.getThrownUuid(stack) != null && ChainBlockItem.getThrownEntity(world, stack) == null) {
            stack.func_77978_p().func_82580_o(THROWN_UUID_KEY);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ChainBlockItem.getThrownUuid(stack) != null) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        player.func_184185_a(TFSounds.BLOCKCHAIN_FIRED, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
        if (!world.field_72995_K) {
            ChainBlockEntity launchedBlock = new ChainBlockEntity(TFEntities.chain_block, world, (LivingEntity)player, hand);
            world.func_217376_c((Entity)launchedBlock);
            ChainBlockItem.setThrownEntity(stack, launchedBlock);
            stack.func_222118_a(1, (LivingEntity)player, user -> user.func_213334_d(hand));
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Nullable
    protected static UUID getThrownUuid(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_186855_b(THROWN_UUID_KEY)) {
            return stack.func_77978_p().func_186857_a(THROWN_UUID_KEY);
        }
        return null;
    }

    @Nullable
    private static ChainBlockEntity getThrownEntity(World world, ItemStack stack) {
        Entity e;
        UUID id;
        if (world instanceof ServerWorld && (id = ChainBlockItem.getThrownUuid(stack)) != null && (e = ((ServerWorld)world).func_217461_a(id)) instanceof ChainBlockEntity) {
            return (ChainBlockEntity)e;
        }
        return null;
    }

    private static void setThrownEntity(ItemStack stack, ChainBlockEntity cube) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_186854_a(THROWN_UUID_KEY, cube.func_110124_au());
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (tool == ToolType.PICKAXE) {
            return 2;
        }
        return -1;
    }
}

