/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.TFSounds;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.util.WorldUtil;

public class CrumbleHornItem
extends Item {
    private static final int CHANCE_HARVEST = 20;
    private static final int CHANCE_CRUMBLE = 5;
    private final List<Pair<Predicate<BlockState>, UnaryOperator<BlockState>>> crumbleTransforms = new ArrayList<Pair<Predicate<BlockState>, UnaryOperator<BlockState>>>();
    private final List<Predicate<BlockState>> harvestedStates = new ArrayList<Predicate<BlockState>>();

    CrumbleHornItem(Item.Properties props) {
        super(props);
        this.addCrumbleTransforms();
    }

    private void addCrumbleTransforms() {
        this.addCrumble(() -> Blocks.field_196696_di, () -> ((Block)Blocks.field_196700_dk).func_176223_P());
        this.addCrumble(() -> Blocks.field_235411_nu_, () -> ((Block)Blocks.field_235412_nv_).func_176223_P());
        this.addCrumble(() -> Blocks.field_235412_nv_, () -> ((Block)Blocks.field_235406_np_).func_176223_P());
        this.addCrumble(() -> Blocks.field_196653_dH, () -> ((Block)Blocks.field_235394_nH_).func_176223_P());
        this.addCrumble((Supplier<Block>)TFBlocks.maze_stone_brick, () -> ((Block)TFBlocks.maze_stone_cracked.get()).func_176223_P());
        this.addCrumble((Supplier<Block>)TFBlocks.underbrick, () -> ((Block)TFBlocks.underbrick_cracked.get()).func_176223_P());
        this.addCrumble((Supplier<Block>)TFBlocks.tower_wood, () -> ((Block)TFBlocks.tower_wood_cracked.get()).func_176223_P());
        this.addCrumble((Supplier<Block>)TFBlocks.deadrock, () -> ((Block)TFBlocks.deadrock_cracked.get()).func_176223_P());
        this.addCrumble((Supplier<Block>)TFBlocks.castle_brick, () -> ((Block)TFBlocks.castle_brick_cracked.get()).func_176223_P());
        this.addCrumble((Supplier<Block>)TFBlocks.nagastone_pillar, () -> ((Block)TFBlocks.nagastone_pillar_weathered.get()).func_176223_P());
        this.addCrumble((Supplier<Block>)TFBlocks.etched_nagastone, () -> ((Block)TFBlocks.etched_nagastone_weathered.get()).func_176223_P());
        this.addCrumble(() -> Blocks.field_150348_b, () -> ((Block)Blocks.field_150347_e).func_176223_P());
        this.addCrumble(() -> Blocks.field_150347_e, () -> ((Block)Blocks.field_150351_n).func_176223_P());
        this.addCrumble(() -> Blocks.field_150322_A, () -> ((Block)Blocks.field_150354_m).func_176223_P());
        this.addCrumble(() -> Blocks.field_180395_cM, () -> ((Block)Blocks.field_196611_F).func_176223_P());
        this.addCrumble(() -> Blocks.field_196658_i, () -> ((Block)Blocks.field_150346_d).func_176223_P());
        this.addCrumble(() -> Blocks.field_150391_bh, () -> ((Block)Blocks.field_150346_d).func_176223_P());
        this.addCrumble(() -> Blocks.field_196661_l, () -> ((Block)Blocks.field_150346_d).func_176223_P());
        this.addCrumble(() -> Blocks.field_196660_k, () -> ((Block)Blocks.field_150346_d).func_176223_P());
        this.addCrumble(() -> Blocks.field_235381_mu_, () -> ((Block)Blocks.field_150424_aL).func_176223_P());
        this.addCrumble(() -> Blocks.field_235372_ml_, () -> ((Block)Blocks.field_150424_aL).func_176223_P());
        this.addCrumble(() -> Blocks.field_150371_ca, () -> ((Block)Blocks.field_150354_m).func_176223_P());
        this.addHarvest(() -> Blocks.field_150351_n);
        this.addHarvest(() -> Blocks.field_150346_d);
        this.addHarvest(() -> Blocks.field_150354_m);
        this.addHarvest(() -> Blocks.field_196611_F);
        this.addHarvest(() -> Blocks.field_150435_aG);
        this.addHarvest(() -> Blocks.field_196656_g);
        this.addHarvest(() -> Blocks.field_196650_c);
        this.addHarvest(() -> Blocks.field_196654_e);
    }

    private void addCrumble(Supplier<Block> block, Supplier<BlockState> result) {
        this.addCrumble((BlockState state) -> state.func_177230_c() == block.get(), state -> (BlockState)result.get());
    }

    private void addCrumble(Predicate<BlockState> test, UnaryOperator<BlockState> transform) {
        this.crumbleTransforms.add((Pair<Predicate<BlockState>, UnaryOperator<BlockState>>)Pair.of(test, transform));
    }

    private void addHarvest(Supplier<Block> block) {
        this.addHarvest((BlockState state) -> state.func_177230_c() == block.get());
    }

    private void addHarvest(Predicate<BlockState> test) {
        this.harvestedStates.add(test);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        player.func_184598_c(hand);
        player.func_184185_a(TFSounds.QUEST_RAM_AMBIENT, 1.0f, 0.8f);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        if (count > 10 && count % 5 == 0 && !living.field_70170_p.field_72995_K) {
            int crumbled = this.doCrumble(stack, living.field_70170_p, living);
            if (crumbled > 0) {
                stack.func_222118_a(crumbled, living, user -> user.func_213334_d(living.func_184600_cs()));
            }
            living.field_70170_p.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), TFSounds.QUEST_RAM_AMBIENT, living.func_184176_by(), 1.0f, 0.8f);
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() == newStack.func_77973_b();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b();
    }

    private int doCrumble(ItemStack stack, World world, LivingEntity living) {
        double range = 3.0;
        double radius = 2.0;
        Vector3d srcVec = new Vector3d(living.func_226277_ct_(), living.func_226278_cu_() + (double)living.func_70047_e(), living.func_226281_cx_());
        Vector3d lookVec = living.func_70040_Z().func_186678_a(3.0);
        Vector3d destVec = srcVec.func_178787_e(lookVec);
        AxisAlignedBB crumbleBox = new AxisAlignedBB(destVec.field_72450_a - 2.0, destVec.field_72448_b - 2.0, destVec.field_72449_c - 2.0, destVec.field_72450_a + 2.0, destVec.field_72448_b + 2.0, destVec.field_72449_c + 2.0);
        return this.crumbleBlocksInAABB(stack, world, living, crumbleBox);
    }

    private int crumbleBlocksInAABB(ItemStack stack, World world, LivingEntity living, AxisAlignedBB box) {
        int crumbled = 0;
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            if (!this.crumbleBlock(stack, world, living, pos)) continue;
            ++crumbled;
        }
        return crumbled;
    }

    private boolean crumbleBlock(ItemStack stack, World world, LivingEntity living, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockReader)world, pos)) {
            return false;
        }
        if (living instanceof PlayerEntity && MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, (PlayerEntity)living))) {
            return false;
        }
        for (Pair<Predicate<BlockState>, UnaryOperator<BlockState>> pair : this.crumbleTransforms) {
            if (!((Predicate)pair.getLeft()).test(state) || world.field_73012_v.nextInt(5) != 0) continue;
            world.func_180501_a(pos, (BlockState)((UnaryOperator)pair.getRight()).apply(state), 3);
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            this.postTrigger(living, stack, world, pos);
            return true;
        }
        for (Predicate predicate : this.harvestedStates) {
            if (!predicate.test(state) || world.field_73012_v.nextInt(20) != 0) continue;
            if (living instanceof PlayerEntity) {
                if (!block.canHarvestBlock(state, (IBlockReader)world, pos, (PlayerEntity)living)) continue;
                world.func_217377_a(pos, false);
                block.func_180657_a(world, (PlayerEntity)living, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                this.postTrigger(living, stack, world, pos);
                return true;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)living)) continue;
            world.func_175655_b(pos, true);
            this.postTrigger(living, stack, world, pos);
            return true;
        }
        return false;
    }

    private void postTrigger(LivingEntity living, ItemStack stack, World world, BlockPos pos) {
        if (living instanceof ServerPlayerEntity) {
            TFAdvancements.ITEM_USE_TRIGGER.trigger((ServerPlayerEntity)living, stack, world, pos);
        }
    }
}

