/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFSounds;
import twilightforest.block.TFBlocks;

public class LampOfCindersItem
extends Item {
    private static final int FIRING_TIME = 12;

    LampOfCindersItem(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (this.burnBlock(world, pos)) {
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, player.func_184586_b(context.func_221531_n()));
            }
            player.func_184185_a(TFSounds.LAMP_BURN, 0.5f, 1.5f);
            for (int i = 0; i < 10; ++i) {
                float dx = (float)pos.func_177958_n() + 0.5f + (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.75f;
                float dy = (float)pos.func_177956_o() + 0.5f + (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.75f;
                float dz = (float)pos.func_177952_p() + 0.5f + (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.75f;
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)dx, (double)dy, (double)dz, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)dx, (double)dy, (double)dz, 0.0, 0.0, 0.0);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private boolean burnBlock(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == TFBlocks.brown_thorns.get() || state.func_177230_c() == TFBlocks.green_thorns.get()) {
            world.func_175656_a(pos, (BlockState)((Block)TFBlocks.burnt_thorns.get()).func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, state.func_177229_b((Property)RotatedPillarBlock.field_176298_M)));
            return true;
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int useRemaining) {
        int useTime = this.func_77626_a(stack) - useRemaining;
        if (useTime > 12 && stack.func_77952_i() + 1 < this.getMaxDamage(stack)) {
            this.doBurnEffect(world, living);
        }
    }

    private void doBurnEffect(World world, LivingEntity living) {
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)living.field_70142_S), MathHelper.func_76128_c((double)(living.field_70137_T + (double)living.func_70047_e())), MathHelper.func_76128_c((double)living.field_70136_U));
        int range = 4;
        if (!world.field_72995_K) {
            world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), TFSounds.LAMP_BURN, living.func_184176_by(), 1.5f, 0.8f);
            for (int dx = -range; dx <= range; ++dx) {
                for (int dy = -range; dy <= range; ++dy) {
                    for (int dz = -range; dz <= range; ++dz) {
                        this.burnBlock(world, pos.func_177982_a(dx, dy, dz));
                    }
                }
            }
        }
        if (living instanceof PlayerEntity) {
            for (int i = 0; i < 6; ++i) {
                BlockPos rPos = pos.func_177982_a(field_77697_d.nextInt(range) - field_77697_d.nextInt(range), field_77697_d.nextInt(2), field_77697_d.nextInt(range) - field_77697_d.nextInt(range));
                world.func_217378_a((PlayerEntity)living, 2004, rPos, 0);
            }
            for (LivingEntity targets : world.func_217357_a(LivingEntity.class, new AxisAlignedBB(new BlockPos(living.func_226277_ct_(), living.func_226280_cw_(), living.func_226281_cx_())).func_186662_g(4.0))) {
                if (targets instanceof PlayerEntity) continue;
                targets.func_70015_d(5);
            }
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }
}

