/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraftforge.common.world.StructureSpawnManager;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.start.TFStructure;
import twilightforest.util.IntPair;
import twilightforest.world.ChunkBitArray;

public abstract class ChunkGeneratorTwilightBase
extends NoiseChunkGenerator {
    protected final long seed;
    protected final Supplier<DimensionSettings> dimensionSettings;
    private final boolean shouldGenerateBedrock;

    public ChunkGeneratorTwilightBase(BiomeProvider provider, long seed, Supplier<DimensionSettings> settings, boolean shouldGenerateBedrock) {
        super(provider, seed, settings);
        this.seed = seed;
        this.dimensionSettings = settings;
        this.shouldGenerateBedrock = shouldGenerateBedrock;
    }

    public ChunkGeneratorTwilightBase(BiomeProvider provider, long seed, Supplier<DimensionSettings> settings) {
        this(provider, seed, settings, true);
    }

    public int func_205470_d() {
        return 32;
    }

    protected static int getIndex(int x, int y, int z) {
        return x << 12 | z << 8 | y;
    }

    protected final void squishTerrain(ChunkBitArray data) {
        int squishHeight = 128;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                for (y = 0; y < squishHeight; ++y) {
                    data.set(ChunkGeneratorTwilightBase.getIndex(x, y, z), data.get(ChunkGeneratorTwilightBase.getIndex(x, y * 2 + 1, z)));
                }
                for (y = squishHeight; y < 256; ++y) {
                    data.clear(ChunkGeneratorTwilightBase.getIndex(x, y, z));
                }
            }
        }
    }

    protected final void deformTerrainForFeature(WorldGenRegion primer) {
        IntPair nearCenter = new IntPair();
        TFFeature nearFeature = TFFeature.getNearestFeature(this.getPos((WorldGenRegion)primer).field_77276_a, this.getPos((WorldGenRegion)primer).field_77275_b, (ISeedReader)primer, nearCenter);
        if (!nearFeature.isTerrainAltered) {
            return;
        }
        int hx = nearCenter.x;
        int hz = nearCenter.z;
        if (nearFeature == TFFeature.TROLL_CAVE) {
            this.deformTerrainForTrollCloud2(primer, nearFeature, hx, hz);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int dx = x - hx;
                int dz = z - hz;
                if (nearFeature == TFFeature.SMALL_HILL || nearFeature == TFFeature.MEDIUM_HILL || nearFeature == TFFeature.LARGE_HILL || nearFeature == TFFeature.HYDRA_LAIR) {
                    int hdiam = (nearFeature.size * 2 + 1) * 16;
                    int dist = (int)Math.sqrt(dx * dx + dz * dz);
                    int hheight = (int)(Math.cos((double)((float)dist / (float)hdiam) * Math.PI) * (double)((float)hdiam / 3.0f));
                    this.raiseHills(primer, nearFeature, hdiam, x, z, dx, dz, hheight);
                    continue;
                }
                if (nearFeature == TFFeature.HEDGE_MAZE || nearFeature == TFFeature.NAGA_COURTYARD || nearFeature == TFFeature.QUEST_GROVE) {
                    this.flattenTerrainForFeature(primer, nearFeature, x, z, dx, dz);
                    continue;
                }
                if (nearFeature == TFFeature.YETI_CAVE) {
                    this.deformTerrainForYetiLair(primer, nearFeature, x, z, dx, dz);
                    continue;
                }
                if (nearFeature != TFFeature.TROLL_CAVE) continue;
                this.deformTerrainForTrollCaves(primer, nearFeature, x, z, dx, dz);
            }
        }
    }

    protected void deformTerrainForTrollCaves(WorldGenRegion primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
    }

    private void deformTerrainForTrollCloud2(WorldGenRegion primer, TFFeature nearFeature, int hx, int hz) {
        for (int bx = 0; bx < 4; ++bx) {
            for (int bz = 0; bz < 4; ++bz) {
                int dx = bx * 4 - hx - 2;
                int dz = bz * 4 - hz - 2;
                int regionX = this.getPos((WorldGenRegion)primer).field_77276_a + 8 >> 4;
                int regionZ = this.getPos((WorldGenRegion)primer).field_77275_b + 8 >> 4;
                long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
                seed = seed * seed * 42317861L + seed * 7L;
                int num0 = (int)(seed >> 12 & 3L);
                int num1 = (int)(seed >> 15 & 3L);
                int num2 = (int)(seed >> 18 & 3L);
                int num3 = (int)(seed >> 21 & 3L);
                int num4 = (int)(seed >> 9 & 3L);
                int num5 = (int)(seed >> 6 & 3L);
                int num6 = (int)(seed >> 3 & 3L);
                int num7 = (int)(seed >> 0 & 3L);
                int dx2 = dx + num0 * 5 - num1 * 4;
                int dz2 = dz + num2 * 4 - num3 * 5;
                int dx3 = dx + num4 * 5 - num5 * 4;
                int dz3 = dz + num6 * 4 - num7 * 5;
                double dist0 = Math.sqrt(dx * dx + dz * dz) / 4.0;
                double dist2 = Math.sqrt(dx2 * dx2 + dz2 * dz2) / 3.5;
                double dist3 = Math.sqrt(dx3 * dx3 + dz3 * dz3) / 4.5;
                double dist = Math.min(dist0, Math.min(dist2, dist3));
                float pr = primer.func_201674_k().nextFloat();
                double cv = dist - 7.0 - (double)(pr * 3.0f);
                int y = 166;
                int depth = 4;
                if (pr < 0.1f) {
                    ++y;
                }
                if (pr > 0.6f) {
                    ++depth;
                }
                if (pr > 0.9f) {
                    ++depth;
                }
                for (int sx = 0; sx < 4; ++sx) {
                    for (int sz = 0; sz < 4; ++sz) {
                        int d;
                        int lx = bx * 4 + sx;
                        int lz = bz * 4 + sz;
                        if (dist < 7.0 || cv < (double)0.05f) {
                            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(lx, 0, lz), y), ((Block)TFBlocks.wispy_cloud.get()).func_176223_P(), 3);
                            for (d = 1; d < depth; ++d) {
                                primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(lx, 0, lz), y - d), ((Block)TFBlocks.fluffy_cloud.get()).func_176223_P(), 3);
                            }
                            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(lx, 0, lz), y - depth), ((Block)TFBlocks.wispy_cloud.get()).func_176223_P(), 3);
                            continue;
                        }
                        if (!(dist < 8.0) && !(cv < 1.0)) continue;
                        for (d = 1; d < depth; ++d) {
                            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(lx, 0, lz), y - d), ((Block)TFBlocks.fluffy_cloud.get()).func_176223_P(), 3);
                        }
                    }
                }
            }
        }
    }

    private void raiseHills(WorldGenRegion primer, TFFeature nearFeature, int hdiam, int x, int z, int dx, int dz, int hillHeight) {
        int y;
        int y2;
        int oldGround = -1;
        int newGround = -1;
        boolean foundGroundLevel = false;
        for (y2 = 31; y2 < 256; ++y2) {
            Block currentTerrain = primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y2)).func_177230_c();
            if (currentTerrain == Blocks.field_150348_b) continue;
            oldGround = y2;
            newGround = y2 + hillHeight;
            foundGroundLevel = true;
            break;
        }
        if (foundGroundLevel) {
            for (y2 = oldGround; y2 <= newGround; ++y2) {
                primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y2), Blocks.field_150348_b.func_176223_P(), 3);
            }
        }
        int hollow = hillHeight - 4 - nearFeature.size;
        if (nearFeature == TFFeature.HYDRA_LAIR) {
            int mx = dx + 16;
            int mz = dz + 16;
            int mdist = (int)Math.sqrt(mx * mx + mz * mz);
            int mheight = (int)(Math.cos((double)mdist / ((double)hdiam / 1.5) * Math.PI) * ((double)hdiam / 1.5));
            hollow = Math.max(mheight - 4, hollow);
        }
        if (hollow < 0) {
            hollow = 0;
        }
        int hollowFloor = 26 - hollow / 8;
        if (nearFeature == TFFeature.HYDRA_LAIR) {
            hollowFloor = 31;
        }
        if (hillHeight > 0) {
            for (y = 0; y < 31; ++y) {
                if (primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y)).func_177230_c() == Blocks.field_150348_b) continue;
                primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), Blocks.field_150348_b.func_176223_P(), 3);
            }
        }
        for (y = hollowFloor + 1; y < hollowFloor + hollow; ++y) {
            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private void flattenTerrainForFeature(WorldGenRegion primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        Block b;
        int y;
        float squishFactor = 0.0f;
        int mazeHeight = 32;
        int FEATURE_BOUNDARY = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -FEATURE_BOUNDARY) {
            squishFactor = (float)(-dx - FEATURE_BOUNDARY) / 8.0f;
        } else if (dx >= FEATURE_BOUNDARY) {
            squishFactor = (float)(dx - FEATURE_BOUNDARY) / 8.0f;
        }
        if (dz <= -FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(-dz - FEATURE_BOUNDARY) / 8.0f);
        } else if (dz >= FEATURE_BOUNDARY) {
            squishFactor = Math.max(squishFactor, (float)(dz - FEATURE_BOUNDARY) / 8.0f);
        }
        if (squishFactor > 0.0f) {
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y)).func_177230_c();
                if (currentTerrain == Blocks.field_150348_b) continue;
                mazeHeight = (int)((float)mazeHeight + (float)(y - mazeHeight) * squishFactor);
                break;
            }
        }
        for (y = 0; y < mazeHeight; ++y) {
            b = primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y)).func_177230_c();
            if (b != Blocks.field_150350_a && b != Blocks.field_150355_j) continue;
            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), Blocks.field_150348_b.func_176223_P(), 3);
        }
        for (y = mazeHeight; y <= 127; ++y) {
            b = primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y)).func_177230_c();
            if (b == Blocks.field_150350_a || b == Blocks.field_150355_j) continue;
            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private void deformTerrainForYetiLair(WorldGenRegion primer, TFFeature nearFeature, int x, int z, int dx, int dz) {
        int y;
        float squishFactor = 0.0f;
        int topHeight = 55;
        int outerBoundary = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -outerBoundary) {
            squishFactor = (float)(-dx - outerBoundary) / 8.0f;
        } else if (dx >= outerBoundary) {
            squishFactor = (float)(dx - outerBoundary) / 8.0f;
        }
        if (dz <= -outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(-dz - outerBoundary) / 8.0f);
        } else if (dz >= outerBoundary) {
            squishFactor = Math.max(squishFactor, (float)(dz - outerBoundary) / 8.0f);
        }
        int caveBoundary = nearFeature.size * 2 * 8 - 8;
        int offset = Math.min(Math.abs(dx), Math.abs(dz));
        int hollowCeiling = 71 - offset * 4;
        if (dx >= -caveBoundary && dz >= -caveBoundary && dx <= caveBoundary && dz <= caveBoundary) {
            hollowCeiling = 47;
        }
        hollowCeiling -= offset / 6;
        hollowCeiling = Math.min(hollowCeiling, 47);
        int hollowFloor = 27 + offset / 6;
        if (squishFactor > 0.0f) {
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y)).func_177230_c();
                if (currentTerrain == Blocks.field_150348_b) continue;
                topHeight = (int)((float)topHeight + (float)(y - topHeight) * squishFactor);
                hollowFloor = (int)((float)hollowFloor + (float)(y - hollowFloor) * squishFactor);
                break;
            }
        }
        for (y = 0; y < topHeight; ++y) {
            Block b = primer.func_180495_p(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y)).func_177230_c();
            if (b != Blocks.field_150350_a && b != Blocks.field_150355_j) continue;
            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), Blocks.field_150348_b.func_176223_P(), 3);
        }
        for (y = hollowFloor + 1; y < hollowCeiling; ++y) {
            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), y), Blocks.field_150350_a.func_176223_P(), 3);
        }
        if (hollowFloor < hollowCeiling && hollowFloor < 34) {
            primer.func_180501_a(this.withY(this.getPos(primer).func_206849_h().func_177982_a(x, 0, z), hollowFloor), Blocks.field_150403_cj.func_176223_P(), 3);
        }
    }

    public final boolean shouldGenerateBedrock() {
        return this.shouldGenerateBedrock;
    }

    protected final ChunkPos getPos(WorldGenRegion primer) {
        return new ChunkPos(primer.func_201679_a(), primer.func_201680_b());
    }

    protected final BlockPos withY(BlockPos old, int y) {
        return new BlockPos(old.func_177958_n(), y, old.func_177952_p());
    }

    public List<MobSpawnInfo.Spawners> func_230353_a_(Biome biome, StructureManager structureManager, EntityClassification classification, BlockPos pos) {
        List<MobSpawnInfo.Spawners> potentialStructureSpawns = TFStructure.gatherPotentialSpawns(structureManager, classification, pos);
        if (potentialStructureSpawns != null) {
            return potentialStructureSpawns;
        }
        List spawns = StructureSpawnManager.getStructureSpawns((StructureManager)structureManager, (EntityClassification)classification, (BlockPos)pos);
        if (spawns != null) {
            return spawns;
        }
        return classification == EntityClassification.MONSTER && pos.func_177956_o() >= 31 ? ImmutableList.of() : super.func_230353_a_(biome, structureManager, classification, pos);
    }
}

