/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.potions.TFPotions;
import twilightforest.structures.start.TFStructure;
import twilightforest.util.PlayerHelper;
import twilightforest.world.ChunkGeneratorTwilightBase;
import twilightforest.worldgen.biomes.BiomeKeys;

public class TFGenerationSettings {
    private static final Map<ResourceLocation, ResourceLocation[]> BIOME_ADVANCEMENTS = new HashMap<ResourceLocation, ResourceLocation[]>();
    private static final Map<ResourceLocation, BiConsumer<PlayerEntity, World>> BIOME_PROGRESSION_ENFORCEMENT = new HashMap<ResourceLocation, BiConsumer<PlayerEntity, World>>();
    public static final int SEALEVEL = 31;
    public static final int CHUNKHEIGHT = 256;
    public static final int MAXHEIGHT = 256;

    private static void registerBiomeAdvancementRestriction(RegistryKey<Biome> biome, ResourceLocation ... advancements) {
        BIOME_ADVANCEMENTS.put(biome.func_240901_a_(), advancements);
    }

    private static void registerBiomeProgressionEnforcement(RegistryKey<Biome> biome, BiConsumer<PlayerEntity, World> exec) {
        BIOME_PROGRESSION_ENFORCEMENT.put(biome.func_240901_a_(), exec);
    }

    public static void enforceBiomeProgression(PlayerEntity player, World world) {
        Biome currentBiome = world.func_226691_t_(player.func_233580_cy_());
        if (TFGenerationSettings.isBiomeSafeFor(currentBiome, (Entity)player)) {
            return;
        }
        BiConsumer<PlayerEntity, World> exec = BIOME_PROGRESSION_ENFORCEMENT.get(currentBiome.getRegistryName());
        if (exec != null) {
            exec.accept(player, world);
        }
    }

    private static void trySpawnHintMonster(PlayerEntity player, World world, TFFeature feature) {
        if (world.field_73012_v.nextInt(4) == 0) {
            feature.trySpawnHintMonster(world, player);
        }
    }

    @Nullable
    public static ChunkGeneratorTwilightBase getChunkGenerator(World world) {
        if (world instanceof ServerWorld) {
            ChunkGenerator chunkGenerator = ((ServerWorld)world).func_72863_F().field_186029_c;
            return chunkGenerator instanceof ChunkGeneratorTwilightBase ? (ChunkGeneratorTwilightBase)chunkGenerator : null;
        }
        return null;
    }

    public static boolean isStrictlyTwilightForest(World world) {
        return world.func_234923_W_().func_240901_a_().toString().equals(TFConfig.COMMON_CONFIG.DIMENSION.twilightForestID.get());
    }

    public static boolean isTwilightChunk(ServerWorld world) {
        return world.func_72863_F().field_186029_c instanceof ChunkGeneratorTwilightBase;
    }

    public static boolean isProgressionEnforced(World world) {
        return world.func_82736_K().func_223586_b(TwilightForestMod.ENFORCED_PROGRESSION_RULE);
    }

    public static boolean isBiomeSafeFor(Biome biome, Entity entity) {
        ResourceLocation[] advancements = BIOME_ADVANCEMENTS.get(entity.field_70170_p.func_201670_d() ? entity.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome) : biome.getRegistryName());
        if (advancements != null && entity instanceof PlayerEntity) {
            return PlayerHelper.doesPlayerHaveRequiredAdvancements((PlayerEntity)entity, advancements);
        }
        return true;
    }

    public static void markStructureConquered(World world, BlockPos pos, TFFeature feature) {
        ChunkGeneratorTwilightBase generator = TFGenerationSettings.getChunkGenerator(world);
        if (generator == null || TFFeature.getFeatureAt(pos.func_177958_n(), pos.func_177952_p(), (ISeedReader)((ServerWorld)world)) == feature) {
            // empty if block
        }
    }

    public static Optional<StructureStart<?>> locateTFStructureInRange(ISeedReader world, BlockPos pos, int range) {
        int cx1 = MathHelper.func_76141_d((float)(pos.func_177958_n() - range >> 4));
        int cx2 = MathHelper.func_76123_f((float)(pos.func_177958_n() + range >> 4));
        int cz1 = MathHelper.func_76141_d((float)(pos.func_177952_p() - range >> 4));
        int cz2 = MathHelper.func_76123_f((float)(pos.func_177952_p() + range >> 4));
        TFFeature featureCheck = TFFeature.getFeatureForRegionPos(pos.func_177958_n(), pos.func_177952_p(), world);
        for (Structure structureFeature : ForgeRegistries.STRUCTURE_FEATURES) {
            TFFeature feature;
            if (!(structureFeature instanceof TFStructure) || (feature = ((TFStructure)structureFeature).getFeature()) != featureCheck) continue;
            for (int x = cx1; x <= cx2; ++x) {
                for (int z = cz1; z <= cz2; ++z) {
                    Optional<StructureStart<?>> structure = world.func_217348_a(x, z, ChunkStatus.field_222606_b).func_230346_b_(structureFeature).stream().map(longVal -> SectionPos.func_218156_a((ChunkPos)new ChunkPos(longVal.longValue()), (int)0)).map(sectionPos -> world.func_217354_b(sectionPos.func_218149_a(), sectionPos.func_218148_c()) ? world.func_217348_a(sectionPos.func_218149_a(), sectionPos.func_218148_c(), ChunkStatus.field_222606_b).func_230342_a_(structureFeature) : null).filter(structureStart -> structureStart != null && structureStart.func_75069_d()).findFirst();
                    if (!structure.isPresent()) continue;
                    return structure;
                }
            }
        }
        return Optional.empty();
    }

    static {
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.DARK_FOREST, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.DARK_FOREST_CENTER, TwilightForestMod.prefix("progress_knights"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.FINAL_PLATEAU, TwilightForestMod.prefix("progress_troll"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.FIRE_SWAMP, TwilightForestMod.prefix("progress_labyrinth"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.GLACIER, TwilightForestMod.prefix("progress_yeti"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.HIGHLANDS, TwilightForestMod.prefix("progress_merge"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.SNOWY_FOREST, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.SWAMP, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.THORNLANDS, TwilightForestMod.prefix("progress_troll"));
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.DARK_FOREST, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
                player.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.KNIGHT_STRONGHOLD);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.DARK_FOREST_CENTER, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
                player.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.DARK_TOWER);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.FINAL_PLATEAU, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 5 == 0) {
                player.func_70097_a(DamageSource.field_76376_m, 1.5f);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187541_bC, SoundCategory.PLAYERS, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.FIRE_SWAMP, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
                player.func_70015_d(8);
            }
            TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.HYDRA_LAIR);
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.GLACIER, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
                player.func_195064_c(new EffectInstance((Effect)TFPotions.frosty.get(), 100, 3));
            }
            TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.ICE_TOWER);
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.HIGHLANDS, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 5 == 0) {
                player.func_70097_a(DamageSource.field_76376_m, 0.5f);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187541_bC, SoundCategory.PLAYERS, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.SNOWY_FOREST, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
                player.func_195064_c(new EffectInstance((Effect)TFPotions.frosty.get(), 100, 2));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.YETI_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.SWAMP, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
                EffectInstance currentHunger = player.func_70660_b(Effects.field_76438_s);
                int hungerLevel = currentHunger != null ? currentHunger.func_76458_c() + 1 : 1;
                player.func_195064_c(new EffectInstance(Effects.field_76438_s, 100, hungerLevel));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.LABYRINTH);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.THORNLANDS, (player, world) -> {
            if (!world.field_72995_K && player.field_70173_aa % 5 == 0) {
                player.func_70097_a(DamageSource.field_76376_m, 1.0f);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187541_bC, SoundCategory.PLAYERS, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
    }
}

