/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import twilightforest.block.TFBlocks;
import twilightforest.util.FeatureUtil;

public class TFGenFallenSmallLog
extends Feature<NoFeatureConfig> {
    public TFGenFallenSmallLog(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockState branchState;
        BlockState logState;
        boolean goingX = rand.nextBoolean();
        int length = rand.nextInt(4) + 3;
        if (goingX ? !FeatureUtil.isAreaSuitable((IWorld)world, pos, length, 3, 2) : !FeatureUtil.isAreaSuitable((IWorld)world, pos, 3, length, 2)) {
            return false;
        }
        switch (rand.nextInt(7)) {
            default: {
                logState = ((RotatedPillarBlock)TFBlocks.oak_log.get()).func_176223_P();
                break;
            }
            case 1: {
                logState = ((RotatedPillarBlock)TFBlocks.canopy_log.get()).func_176223_P();
                break;
            }
            case 2: {
                logState = ((RotatedPillarBlock)TFBlocks.mangrove_log.get()).func_176223_P();
                break;
            }
            case 3: {
                logState = Blocks.field_196617_K.func_176223_P();
                break;
            }
            case 4: {
                logState = Blocks.field_196618_L.func_176223_P();
                break;
            }
            case 5: {
                logState = Blocks.field_196619_M.func_176223_P();
                break;
            }
            case 6: {
                logState = Blocks.field_196620_N.func_176223_P();
            }
        }
        if (goingX) {
            logState = (BlockState)logState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
            branchState = (BlockState)logState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
            for (int lx = 0; lx < length; ++lx) {
                world.func_180501_a(pos.func_177982_a(lx, 0, 1), logState, 3);
                if (rand.nextInt(3) <= 0) continue;
                world.func_180501_a(pos.func_177982_a(lx, 1, 1), ((Block)TFBlocks.moss_patch.get()).func_176223_P(), 3);
            }
        } else {
            logState = (BlockState)logState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
            branchState = (BlockState)logState.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
            for (int lz = 0; lz < length; ++lz) {
                world.func_180501_a(pos.func_177982_a(1, 0, lz), logState, 3);
                if (rand.nextInt(3) <= 0) continue;
                world.func_180501_a(pos.func_177982_a(1, 1, lz), ((Block)TFBlocks.moss_patch.get()).func_176223_P(), 3);
            }
        }
        if (rand.nextInt(3) > 0) {
            int bx;
            if (goingX) {
                bx = rand.nextInt(length);
                int bz = rand.nextBoolean() ? 2 : 0;
                world.func_180501_a(pos.func_177982_a(bx, 0, bz), branchState, 3);
                if (rand.nextBoolean()) {
                    world.func_180501_a(pos.func_177982_a(bx, 1, bz), ((Block)TFBlocks.moss_patch.get()).func_176223_P(), 3);
                }
            } else {
                bx = rand.nextBoolean() ? 2 : 0;
                int bz = rand.nextInt(length);
                world.func_180501_a(pos.func_177982_a(bx, 0, bz), branchState, 3);
                if (rand.nextBoolean()) {
                    world.func_180501_a(pos.func_177982_a(bx, 1, bz), ((Block)TFBlocks.moss_patch.get()).func_176223_P(), 3);
                }
            }
        }
        return true;
    }
}

