/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import twilightforest.block.TFBlocks;
import twilightforest.util.FeatureUtil;
import twilightforest.world.feature.TFTreeGenerator;

public class TFGenWoodRoots
extends Feature<NoFeatureConfig> {
    private BlockState rootBlock = ((Block)TFBlocks.root.get()).func_176223_P();
    private BlockState oreBlock = ((Block)TFBlocks.liveroot_block.get()).func_176223_P();

    public TFGenWoodRoots(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150348_b) {
            return false;
        }
        float length = rand.nextFloat() * 6.0f + rand.nextFloat() * 6.0f + 4.0f;
        if (length > (float)pos.func_177956_o()) {
            length = pos.func_177956_o();
        }
        float tilt = 0.6f + rand.nextFloat() * 0.3f;
        return this.drawRoot((IWorld)world, rand, pos, length, rand.nextFloat(), tilt);
    }

    private boolean drawRoot(IWorld world, Random rand, BlockPos pos, float length, float angle, float tilt) {
        return this.drawRoot(world, rand, pos, pos, length, angle, tilt);
    }

    private boolean drawRoot(IWorld world, Random rand, BlockPos oPos, BlockPos pos, float length, float angle, float tilt) {
        BlockPos[] lineArray;
        BlockPos dest = FeatureUtil.translate(pos, length, angle, tilt);
        int limit = 6;
        if (oPos.func_177958_n() + limit < dest.func_177958_n()) {
            dest = new BlockPos(oPos.func_177958_n() + limit, dest.func_177956_o(), dest.func_177952_p());
        }
        if (oPos.func_177958_n() - limit > dest.func_177958_n()) {
            dest = new BlockPos(oPos.func_177958_n() - limit, dest.func_177956_o(), dest.func_177952_p());
        }
        if (oPos.func_177952_p() + limit < dest.func_177952_p()) {
            dest = new BlockPos(dest.func_177958_n(), dest.func_177956_o(), oPos.func_177952_p() + limit);
        }
        if (oPos.func_177952_p() - limit > dest.func_177952_p()) {
            dest = new BlockPos(dest.func_177958_n(), dest.func_177956_o(), oPos.func_177952_p() - limit);
        }
        if (world.func_180495_p(dest).func_177230_c() != Blocks.field_150348_b) {
            return false;
        }
        for (BlockPos coord : lineArray = FeatureUtil.getBresenhamArrays(pos, dest)) {
            this.placeRootBlock(world, coord, this.rootBlock);
        }
        if (length > 8.0f && rand.nextInt(3) > 0) {
            BlockPos nextSrc = FeatureUtil.translate(pos, length / 2.0f, angle, tilt);
            float nextAngle = (angle + 0.25f + rand.nextFloat() * 0.5f) % 1.0f;
            float nextTilt = 0.6f + rand.nextFloat() * 0.3f;
            this.drawRoot(world, rand, oPos, nextSrc, length / 2.0f, nextAngle, nextTilt);
        }
        if (length > 6.0f && rand.nextInt(4) == 0) {
            BlockPos ballSrc = FeatureUtil.translate(pos, length / 2.0f, angle, tilt);
            BlockPos ballDest = FeatureUtil.translate(ballSrc, 1.5, (angle + 0.5f) % 1.0f, 0.75);
            this.placeRootBlock(world, ballSrc, this.oreBlock);
            this.placeRootBlock(world, new BlockPos(ballSrc.func_177958_n(), ballSrc.func_177956_o(), ballDest.func_177952_p()), this.oreBlock);
            this.placeRootBlock(world, new BlockPos(ballDest.func_177958_n(), ballSrc.func_177956_o(), ballSrc.func_177952_p()), this.oreBlock);
            this.placeRootBlock(world, new BlockPos(ballSrc.func_177958_n(), ballSrc.func_177956_o(), ballDest.func_177952_p()), this.oreBlock);
            this.placeRootBlock(world, new BlockPos(ballSrc.func_177958_n(), ballDest.func_177956_o(), ballSrc.func_177952_p()), this.oreBlock);
            this.placeRootBlock(world, new BlockPos(ballSrc.func_177958_n(), ballDest.func_177956_o(), ballDest.func_177952_p()), this.oreBlock);
            this.placeRootBlock(world, new BlockPos(ballDest.func_177958_n(), ballDest.func_177956_o(), ballSrc.func_177952_p()), this.oreBlock);
            this.placeRootBlock(world, ballDest, this.oreBlock);
        }
        return true;
    }

    protected void placeRootBlock(IWorld world, BlockPos pos, BlockState state) {
        if (TFTreeGenerator.canRootGrowIn((IWorldReader)world, pos)) {
            world.func_180501_a(pos, state, 3);
        }
    }
}

