/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.surfacebuilders;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import twilightforest.world.ChunkGeneratorTwilightBase;
import twilightforest.world.TFGenerationSettings;

public class TFDefaultSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    public TFDefaultSurfaceBuilder(Codec<SurfaceBuilderConfig> config) {
        super(config);
    }

    public void buildSurface(Random rand, IChunk primer, Biome biome, int x, int z, int startheight, double noiseVal, BlockState defaultBlock, BlockState defaultFluid, int sealevel, long seed, SurfaceBuilderConfig config) {
        this.genTwilightBiomeTerrain(rand, primer, biome, x, z, startheight, noiseVal, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), sealevel);
    }

    protected void genTwilightBiomeTerrain(Random rand, IChunk primer, Biome biome, int x, int z, int startHeight, double noiseVal, BlockState defaultBlock, BlockState defaultFluid, BlockState top, BlockState middle, BlockState bottom, int sealevel) {
        BlockState topState = top;
        BlockState middleState = middle;
        int generatedDirtDepth = -1;
        int dirtDepth = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int localX = x & 0xF;
        int localZ = z & 0xF;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        boolean generateBedrock = true;
        for (int y = startHeight; y >= 0; --y) {
            mutable.func_181079_c(localX, y, localZ);
            if (generateBedrock && y <= rand.nextInt(5)) {
                primer.func_177436_a((BlockPos)mutable, Blocks.field_150357_h.func_176223_P(), false);
                continue;
            }
            BlockState stateHere = primer.func_180495_p((BlockPos)mutable);
            if (stateHere.func_177230_c() == Blocks.field_150350_a || stateHere.func_177230_c() != Blocks.field_150348_b) continue;
            if (generatedDirtDepth == -1) {
                if (dirtDepth <= 0) {
                    topState = Blocks.field_150350_a.func_176223_P();
                    middleState = defaultBlock;
                } else if (y >= sealevel - 4 && y <= sealevel + 1) {
                    topState = top;
                    middleState = middle;
                }
                if (y < sealevel && (topState == null || topState.func_177230_c() == Blocks.field_150350_a)) {
                    topState = biome.func_225486_c((BlockPos)mutable.func_181079_c(x, y, z)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : defaultFluid;
                    mutable.func_181079_c(localZ, y, localX);
                }
                generatedDirtDepth = dirtDepth;
                if (y >= sealevel - 1) {
                    primer.func_177436_a((BlockPos)mutable, topState, false);
                    continue;
                }
                if (y < sealevel - 7 - dirtDepth) {
                    topState = Blocks.field_150350_a.func_176223_P();
                    middleState = defaultBlock;
                    primer.func_177436_a((BlockPos)mutable, bottom, false);
                    continue;
                }
                primer.func_177436_a((BlockPos)mutable, middleState, false);
                continue;
            }
            if (generatedDirtDepth <= 0) continue;
            primer.func_177436_a((BlockPos)mutable, middleState, false);
            if (--generatedDirtDepth != 0 || middleState.func_177230_c() != Blocks.field_150354_m) continue;
            generatedDirtDepth = rand.nextInt(4) + Math.max(0, y - 63);
            middleState = middleState == Blocks.field_196611_F.func_176223_P() ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
        }
    }

    private static boolean shouldGenerateBedrock(World world) {
        ChunkGeneratorTwilightBase generator = TFGenerationSettings.getChunkGenerator(world);
        return generator == null || generator.shouldGenerateBedrock();
    }
}

