/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.biomes;

import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GrassColors;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import twilightforest.TwilightForestMod;

public class BiomeGrassColors {
    private static final Random COLOR_RNG = new Random();
    public static final BiomeAmbience.GrassColorModifier ENCHANTED_FOREST = BiomeGrassColors.make("enchanted_forest", (x, z, color) -> (color & 0xFFFF00) + BiomeGrassColors.getEnchantedColor((int)x, (int)z));
    public static final BiomeAmbience.GrassColorModifier SWAMP = BiomeGrassColors.make("swamp", (x, z, color) -> ((GrassColors.func_77480_a((double)0.8f, (double)0.9f) & 0xFEFEFE) + 0x4E0E4E) / 2);
    public static final BiomeAmbience.GrassColorModifier DARK_FOREST = BiomeGrassColors.make("dark_forest", (x, z, color) -> ((GrassColors.func_77480_a((double)0.7f, (double)0.8f) & 0xFEFEFE) + 1969742) / 2);
    public static final BiomeAmbience.GrassColorModifier DARK_FOREST_CENTER = BiomeGrassColors.make("dark_forest_center", (x, z, color) -> {
        double d0 = Biome.field_180281_af.func_215464_a(x * 0.0225, z * 0.0225, false);
        return d0 < -0.2 ? 6714688 : 0x554114;
    });

    private static int getEnchantedColor(int x, int z) {
        int randomFlicker;
        int cx = 256 * Math.round((float)(x - 8) / 256.0f) + 8;
        int cz = 256 * Math.round((float)(z - 8) / 256.0f) + 8;
        int dist = (int)MathHelper.func_76129_c((float)((cx - x) * (cx - x) + (cz - z) * (cz - z)));
        int color = dist * 64;
        if ((color %= 512) > 255) {
            color = 511 - color;
        }
        if (0 < (color = 255 - color) + (randomFlicker = COLOR_RNG.nextInt(32) - 16) && color + randomFlicker > 255) {
            color += randomFlicker;
        }
        return color;
    }

    private static BiomeAmbience.GrassColorModifier make(String name, BiomeAmbience.GrassColorModifier.ColorModifier delegate) {
        name = TwilightForestMod.prefix(name).toString();
        return BiomeAmbience.GrassColorModifier.create((String)name, (String)name, (BiomeAmbience.GrassColorModifier.ColorModifier)delegate);
    }
}

