/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.biomes;

import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import twilightforest.TFStructures;
import twilightforest.entity.TFEntities;
import twilightforest.worldgen.ConfiguredFeatures;
import twilightforest.worldgen.ConfiguredSurfaceBuilders;
import twilightforest.worldgen.ConfiguredWorldCarvers;

public abstract class BiomeHelper {
    public static BiomeGenerationSettings.Builder twilightForestGen(BiomeGenerationSettings.Builder biome) {
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.addCanopyTrees(biome);
        BiomeHelper.addTwilightOakTrees(biome);
        BiomeHelper.addTwilightOakTrees(biome);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addDefaultStructures(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder denseForestGen(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243876_bV);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243876_bV);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.addCanopyTrees(biome);
        BiomeHelper.addCanopyTrees(biome);
        BiomeHelper.addTwilightOakTrees(biome);
        BiomeHelper.addTwilightOakTrees(biome);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addDefaultStructures(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder fireflyForestGen(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.LAMPPOST);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.MUSHGLOOM_CLUSTER);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243845_ar);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243931_cn);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.addFireflyCanopyTrees(biome);
        BiomeHelper.addTwilightOakTrees(biome);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addDefaultStructures(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder oakSavannaGen(BiomeGenerationSettings.Builder biome) {
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.addRareOakTrees(biome);
        BiomeHelper.addDefaultStructures(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder enchantedForestGen(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.FIDDLEHEAD);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243788_N);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.addRainbowOaks(biome);
        BiomeHelper.addCanopyTrees(biome);
        BiomeHelper.addHollowOakTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder spookyForestGen(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.PUMPKIN_LAMPPOST);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.GRASS_PLACER);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.SMALL_LOG);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.WEBS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.FALLEN_LEAVES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243845_ar);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243805_aD);
        biome.func_242513_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ConfiguredFeatures.GRAVEYARD);
        BiomeHelper.addDeadCanopyTrees(biome);
        BiomeHelper.addTwilightOakTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder mushroomForestGen(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.MYCELIUM_BLOB);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.addTwilightOakTrees(biome);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addCanopyMushrooms(biome, false);
        BiomeHelper.addDefaultStructures(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder denseMushroomForestGen(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.MYCELIUM_BLOB);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.addTwilightOakTrees(biome);
        BiomeHelper.addHollowOakTrees(biome);
        BiomeHelper.addCanopyMushrooms(biome, true);
        return biome;
    }

    public static BiomeGenerationSettings.Builder thornlandsGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.CONFIGURED_PLATEAU);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.RANDOM_COMMON_FEATURE);
        BiomeHelper.addThorns(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder highlandsGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.CONFIGURED_HIGHLANDS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.RANDOM_COMMON_FEATURE);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243872_bR);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.MEGA_SPRUCE_TREES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243866_bL);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243872_bR);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243866_bL);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243779_E);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243802_aA);
        BiomeHelper.addSmallStoneClusters(biome);
        BiomeHelper.addHighlandCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder swampGen(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.RANDOM_WATER_FEATURE);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243817_aP);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243788_N);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243805_aD);
        BiomeHelper.addForestVegetation(biome);
        BiomeHelper.addMangroveTrees(biome);
        BiomeHelper.addSwampTrees(biome);
        BiomeHelper.addHollowOakTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder fireSwampGen(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.GRASS_PLACER);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.FIRE_JET);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.SMOKER);
        biome.func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243790_P);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243817_aP);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243788_N);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243882_bb);
        BiomeHelper.addSwampTrees(biome);
        BiomeHelper.addHollowOakTrees(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder darkForestGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder().func_242517_a(net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders.field_244178_j);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_GRASS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_FERNS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_MUSHGLOOMS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_MUSHROOMS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_PUMPKINS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_DEAD_BUSHES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.BUSH_DARK_FOREST_TREES);
        BiomeHelper.addDarkwoodTrees(biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder darkForestCenterGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder().func_242517_a(net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders.field_244178_j);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_GRASS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_FERNS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_MUSHGLOOMS);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARK_DEAD_BUSHES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.BUSH_DARK_FOREST_TREES);
        BiomeHelper.addDarkwoodTrees(biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder snowyForestGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.CONFIGURED_SNOW);
        biome.func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243789_O);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.RANDOM_COMMON_FEATURE);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.SMALL_LOG);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.SNOW_SPRUCE_SNOWY);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.MEGA_SPRUCE_TREES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.SNOW_SPRUCE_SNOWY);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.MEGA_SPRUCE_TREES);
        biome.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ConfiguredFeatures.SNOW_UNDER_TREES);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biome);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static BiomeGenerationSettings.Builder glacierGen() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder().func_242517_a(net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders.field_244178_j);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static void withWoodRoots(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredFeatures.WOOD_ROOTS_SPREAD);
    }

    public static BiomeGenerationSettings.Builder addDefaultStructures(BiomeGenerationSettings.Builder biome) {
        return biome.func_242516_a(TFStructures.CONFIGURED_HEDGE_MAZE).func_242516_a(TFStructures.CONFIGURED_HOLLOW_HILL_SMALL).func_242516_a(TFStructures.CONFIGURED_HOLLOW_HILL_MEDIUM).func_242516_a(TFStructures.CONFIGURED_HOLLOW_HILL_LARGE).func_242516_a(TFStructures.CONFIGURED_NAGA_COURTYARD).func_242516_a(TFStructures.CONFIGURED_LICH_TOWER);
    }

    public static void addThorns(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.THORNS);
    }

    public static void addForestVegetation(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.FOREST_GRASS_PLACER);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.FLOWER_PLACER);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.RANDOM_COMMON_FEATURE);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.RANDOM_FALLEN_FEATURE);
    }

    public static void addCanopyTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.CANOPY_TREES);
    }

    public static void addFireflyCanopyTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.FIREFLY_CANOPY_TREE_MIX);
    }

    public static void addDeadCanopyTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DEAD_CANOPY_TREES);
    }

    public static void addCanopyMushrooms(BiomeGenerationSettings.Builder biome, boolean dense) {
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biome);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243825_aX);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243826_aY);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.VANILLA_TF_BIG_MUSH);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, dense ? ConfiguredFeatures.CANOPY_MUSHROOMS_DENSE : ConfiguredFeatures.CANOPY_MUSHROOMS_SPARSE);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, dense ? ConfiguredFeatures.BIG_MUSHGLOOM : ConfiguredFeatures.MUSHGLOOM_CLUSTER);
    }

    public static void addRainbowOaks(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.RAINBOW_OAK_TREES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.LARGE_RAINBOW_OAK_TREES);
    }

    public static void addMangroveTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.MANGROVE_TREES);
    }

    public static void addDarkwoodTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.DARKWOOD_TREES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.BUSH_DARK_FOREST_TREES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.OAK_DARK_FOREST_TREES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.BIRCH_DARK_FOREST_TREES);
    }

    public static void addTwilightOakTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.TWILIGHT_OAK_TREES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.VANILLA_TF_OAK);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.VANILLA_TF_BIRCH);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.TWILIGHT_OAK_TREES);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.VANILLA_TF_OAK);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.VANILLA_TF_BIRCH);
    }

    public static void addHollowOakTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.HOLLOW_TREE_PLACER);
    }

    public static void addRareOakTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.OAK_TREES_SPARSE);
    }

    public static void addSwampTrees(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ConfiguredFeatures.SWAMPY_OAK_TREES);
    }

    public static void addSmallStoneClusters(BiomeGenerationSettings.Builder biome) {
        biome.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredFeatures.SMALL_ANDESITE);
        biome.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredFeatures.SMALL_DIORITE);
        biome.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ConfiguredFeatures.SMALL_GRANITE);
    }

    public static BiomeAmbience.Builder whiteAshParticles(BiomeAmbience.Builder builder) {
        builder.func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239820_at_, 0.2f));
        return builder;
    }

    public static void addCaves(BiomeGenerationSettings.Builder biome) {
        biome.func_242512_a(GenerationStage.Carving.AIR, ConfiguredWorldCarvers.TFCAVES_CONFIGURED);
        biome.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredFeatures.PLANT_ROOTS);
        biome.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredFeatures.TORCH_BERRIES);
    }

    public static void addHighlandCaves(BiomeGenerationSettings.Builder biome) {
        biome.func_242512_a(GenerationStage.Carving.AIR, ConfiguredWorldCarvers.HIGHLANDCAVES_CONFIGURED);
        biome.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ConfiguredFeatures.TROLL_ROOTS);
    }

    public static MobSpawnInfo.Builder penguinSpawning() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        spawnInfo.func_242572_a(0.2f);
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.penguin, 10, 2, 4));
        return spawnInfo;
    }

    public static MobSpawnInfo.Builder darkForestSpawning() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        spawnInfo.func_242572_a(0.1f);
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 1, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 5, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 5, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.mist_wolf, 10, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.skeleton_druid, 10, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.king_spider, 10, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.kobold, 10, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200759_ay, 1, 1, 1));
        return spawnInfo;
    }

    public static MobSpawnInfo.Builder snowForestSpawning() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        spawnInfo.func_242572_a(0.1f);
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.winter_wolf, 5, 1, 2));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.yeti, 5, 1, 1));
        return spawnInfo;
    }

    public static MobSpawnInfo.Builder ravenSpawning() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        spawnInfo.func_242572_a(0.3f);
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.raven, 10, 4, 4));
        return spawnInfo;
    }

    public static MobSpawnInfo.Builder swampSpawning() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        spawnInfo.func_242572_a(0.2f);
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200797_k, 10, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 10, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.mosquito_swarm, 10, 1, 1));
        return spawnInfo;
    }

    public static MobSpawnInfo.Builder spookSpawning() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        spawnInfo.func_242572_a(0.4f);
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200748_an, 50, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 20, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.skeleton_druid, 5, 1, 1));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200791_e, 20, 4, 4));
        return spawnInfo;
    }

    public static BiomeAmbience.Builder defaultAmbientBuilder() {
        return new BiomeAmbience.Builder().func_235239_a_(12648408).func_235246_b_(4159204).func_235248_c_(329011).func_242539_d(2105930).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235240_a_(ConfiguredFeatures.TFMUSICTYPE);
    }

    public static BiomeGenerationSettings.Builder defaultGenSettingBuilder() {
        BiomeGenerationSettings.Builder biome = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.CONFIGURED_TF_DEFAULT);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biome);
        DefaultBiomeFeatures.func_243755_o((BiomeGenerationSettings.Builder)biome);
        DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)biome);
        DefaultBiomeFeatures.func_243696_J((BiomeGenerationSettings.Builder)biome);
        biome.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243820_aS);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)biome);
        BiomeHelper.addSmallStoneClusters(biome);
        BiomeHelper.withWoodRoots(biome);
        BiomeHelper.addCaves(biome);
        return biome;
    }

    public static MobSpawnInfo.Builder defaultMobSpawning() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        spawnInfo.func_242572_a(0.1f);
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.bighorn_sheep, 12, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.wild_boar, 10, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200795_i, 10, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.deer, 15, 4, 5));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200724_aC, 5, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.tiny_bird, 15, 4, 8));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.squirrel, 10, 2, 4));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.bunny, 10, 4, 5));
        spawnInfo.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(TFEntities.raven, 10, 1, 2));
        spawnInfo.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200748_an, 10, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 10, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200741_ag, 10, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200797_k, 1, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 10, 4, 4));
        spawnInfo.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 1, 1, 4));
        spawnInfo.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(TFEntities.kobold, 10, 2, 4));
        spawnInfo.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200791_e, 10, 1, 2));
        return spawnInfo;
    }

    public static Biome.Builder biomeWithDefaults(BiomeAmbience.Builder biomeAmbience, MobSpawnInfo.Builder mobSpawnInfo, BiomeGenerationSettings.Builder biomeGenerationSettings) {
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.5f).func_205417_d(0.5f).func_235097_a_(biomeAmbience.func_235238_a_()).func_242458_a(mobSpawnInfo.func_242577_b()).func_242457_a(biomeGenerationSettings.func_242508_a()).func_242456_a(Biome.TemperatureModifier.NONE);
    }
}

