/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.structures;

import com.google.common.math.StatsAccumulator;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.entity.TFEntities;
import twilightforest.enums.StructureWoodVariant;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.RandomizedTemplateProcessor;
import twilightforest.structures.TFStructureProcessors;

public class GenDruidHut
extends Feature<NoFeatureConfig> {
    public GenDruidHut(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        Random random = world.func_201674_k();
        TemplateManager templatemanager = world.func_201672_e().func_73046_m().func_240792_aT_();
        Template template = templatemanager.func_200219_b(HutType.values()[random.nextInt(HutType.size)].RL);
        if (template == null) {
            return false;
        }
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[random.nextInt(rotations.length)];
        Mirror[] mirrors = Mirror.values();
        Mirror mirror = mirrors[random.nextInt(mirrors.length + 1) % mirrors.length];
        ChunkPos chunkpos = new ChunkPos(pos.func_177982_a(-8, 0, -8));
        MutableBoundingBox structureboundingbox = new MutableBoundingBox(chunkpos.func_180334_c() + 8, 0, chunkpos.func_180333_d() + 8, chunkpos.func_180332_e() + 8, 255, chunkpos.func_180330_f() + 8);
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
        BlockPos posSnap = chunkpos.func_206849_h().func_177982_a(8, pos.func_177956_o() - 1, 8);
        BlockPos transformedSize = template.func_186257_a(rotation);
        int dx = random.nextInt(17 - transformedSize.func_177958_n());
        int dz = random.nextInt(17 - transformedSize.func_177952_p());
        posSnap.func_177982_a(dx, 0, dz);
        BlockPos.Mutable startPos = new BlockPos.Mutable(posSnap.func_177958_n(), posSnap.func_177956_o(), posSnap.func_177952_p());
        if (!GenDruidHut.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        BlockPos placementPos = template.func_189961_a((BlockPos)startPos, mirror, rotation);
        template.func_237146_a_((IServerWorld)world, placementPos, placementPos, placementsettings.func_215219_b().func_215222_a((StructureProcessor)new HutTemplateProcessor(0.0f, rand.nextInt(), rand.nextInt(), rand.nextInt())), random, 20);
        ArrayList data = new ArrayList(template.func_215381_a(placementPos, placementsettings, Blocks.field_185779_df));
        if (random.nextBoolean()) {
            template = templatemanager.func_200219_b(BasementType.values()[random.nextInt(BasementType.size)].getBasement(random.nextBoolean()));
            if (template == null) {
                return false;
            }
            placementPos = placementPos.func_177979_c(12).func_177967_a(rotation.func_185831_a(mirror.func_185803_b(Direction.NORTH)), 1).func_177967_a(rotation.func_185831_a(mirror.func_185803_b(Direction.EAST)), 1);
            template.func_237146_a_((IServerWorld)world, placementPos, placementPos, placementsettings.func_215219_b().func_215222_a((StructureProcessor)new HutTemplateProcessor(0.0f, rand.nextInt(14), rand.nextInt(14), rand.nextInt(14))), random, 20);
            data.addAll(template.func_215381_a(placementPos, placementsettings, Blocks.field_185779_df));
        }
        data.forEach(info -> {
            if (info.field_186244_c != null && StructureMode.valueOf((String)info.field_186244_c.func_74779_i("mode")) == StructureMode.DATA) {
                String s = info.field_186244_c.func_74779_i("metadata");
                BlockPos blockPos = info.field_186242_a;
                if ("spawner".equals(s)) {
                    MobSpawnerTileEntity ms;
                    if (world.func_217377_a(blockPos, false) && world.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 18) && (ms = (MobSpawnerTileEntity)world.func_175625_s(blockPos)) != null) {
                        ms.func_145881_a().func_200876_a(TFEntities.skeleton_druid);
                    }
                } else if (s.startsWith("loot")) {
                    world.func_217377_a(blockPos, false);
                    BlockState chest = s.endsWith("T") ? Blocks.field_150447_bR.func_176223_P() : Blocks.field_150486_ae.func_176223_P();
                    switch (s.substring(5, 6)) {
                        case "L": {
                            chest = (BlockState)chest.func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)(mirror != Mirror.NONE ? ChestType.RIGHT : ChestType.LEFT));
                            break;
                        }
                        case "R": {
                            chest = (BlockState)chest.func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)(mirror != Mirror.NONE ? ChestType.LEFT : ChestType.RIGHT));
                            break;
                        }
                        default: {
                            chest = (BlockState)chest.func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE);
                        }
                    }
                    switch (s.substring(4, 5)) {
                        case "W": {
                            chest = (BlockState)chest.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)rotation.func_185831_a(mirror.func_185803_b(Direction.WEST)));
                            break;
                        }
                        case "E": {
                            chest = (BlockState)chest.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)rotation.func_185831_a(mirror.func_185803_b(Direction.EAST)));
                            break;
                        }
                        case "S": {
                            chest = (BlockState)chest.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)rotation.func_185831_a(mirror.func_185803_b(Direction.SOUTH)));
                            break;
                        }
                        default: {
                            chest = (BlockState)chest.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)rotation.func_185831_a(mirror.func_185803_b(Direction.NORTH)));
                        }
                    }
                    if (world.func_180501_a(blockPos, chest, 18)) {
                        TFTreasure.basement.generateChestContents(world, blockPos);
                    }
                }
            }
        });
        return true;
    }

    private static boolean offsetToAverageGroundLevel(ISeedReader world, BlockPos.Mutable startPos, BlockPos size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.func_177958_n(); ++dx) {
            for (int dz = 0; dz < size.func_177952_p(); ++dz) {
                int y;
                int x = startPos.func_177958_n() + dx;
                int z = startPos.func_177952_p() + dz;
                for (y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z); y >= 0; --y) {
                    BlockState state = world.func_180495_p(new BlockPos(x, y, z));
                    if (GenDruidHut.isBlockNotOk(state)) {
                        return false;
                    }
                    if (GenDruidHut.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)Math.round(heights.mean());
        int maxY = (int)heights.max();
        startPos.func_185336_p(baseY);
        return GenDruidHut.isAreaClear((IWorld)world, startPos.func_177981_b(maxY - baseY + 1), startPos.func_177971_a((Vector3i)size));
    }

    private static boolean isAreaClear(IWorld world, BlockPos min, BlockPos max) {
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            if (world.func_180495_p(pos).func_185904_a().func_76222_j()) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockOk(BlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151595_p;
    }

    private static boolean isBlockNotOk(BlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151586_h || material == Material.field_151587_i || state.func_177230_c() == Blocks.field_150357_h;
    }

    public static class HutTemplateProcessor
    extends RandomizedTemplateProcessor {
        private final StructureWoodVariant OAK_SWIZZLE;
        private final StructureWoodVariant SPRUCE_SWIZZLE;
        private final StructureWoodVariant BIRCH_SWIZZLE;
        public int dummy = 0;
        public static final Codec<HutTemplateProcessor> codecHutProcessor = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("integrity").orElse((Object)Float.valueOf(1.0f)).forGetter(obj -> Float.valueOf(obj.integrity)), (App)Codec.INT.fieldOf("integrity").orElse((Object)0).forGetter(obj -> obj.dummy), (App)Codec.INT.fieldOf("integrity").orElse((Object)0).forGetter(obj -> obj.dummy), (App)Codec.INT.fieldOf("integrity").orElse((Object)0).forGetter(obj -> obj.dummy)).apply((Applicative)instance, HutTemplateProcessor::new));

        public HutTemplateProcessor(float integrity, int oakSwizzle, int spruceSwizzle, int birchSwizzle) {
            super(integrity);
            int limit = StructureWoodVariant.values().length;
            this.OAK_SWIZZLE = StructureWoodVariant.values()[Math.floorMod(oakSwizzle, limit)];
            this.SPRUCE_SWIZZLE = StructureWoodVariant.values()[Math.floorMod(spruceSwizzle, limit)];
            this.BIRCH_SWIZZLE = StructureWoodVariant.values()[Math.floorMod(birchSwizzle, limit)];
        }

        protected IStructureProcessorType<?> func_215192_a() {
            return TFStructureProcessors.HUT;
        }

        @Nullable
        public Template.BlockInfo process(IWorldReader worldIn, BlockPos pos, BlockPos piecepos, Template.BlockInfo p_215194_3_, Template.BlockInfo blockInfo, PlacementSettings settings, @Nullable Template template) {
            Random random = settings.func_189947_a(pos);
            if (!this.shouldPlaceBlock(random)) {
                return null;
            }
            BlockState state = blockInfo.field_186243_b;
            Block block = state.func_177230_c();
            if (block == Blocks.field_150347_e) {
                return random.nextBoolean() ? blockInfo : new Template.BlockInfo(blockInfo.field_186242_a, Blocks.field_150341_Y.func_176223_P(), null);
            }
            if (block == Blocks.field_150463_bK) {
                return random.nextBoolean() ? blockInfo : new Template.BlockInfo(blockInfo.field_186242_a, Blocks.field_196723_eg.func_176223_P(), null);
            }
            if (block == Blocks.field_196696_di) {
                return random.nextBoolean() ? blockInfo : new Template.BlockInfo(blockInfo.field_186242_a, random.nextInt(2) == 0 ? Blocks.field_196700_dk.func_176223_P() : Blocks.field_196698_dj.func_176223_P(), null);
            }
            StructureWoodVariant type = StructureWoodVariant.getVariantFromBlock(block);
            if (type != null) {
                switch (type) {
                    case OAK: {
                        return new Template.BlockInfo(blockInfo.field_186242_a, StructureWoodVariant.modifyBlockWithType(state, this.OAK_SWIZZLE), null);
                    }
                    case SPRUCE: {
                        return new Template.BlockInfo(blockInfo.field_186242_a, StructureWoodVariant.modifyBlockWithType(state, this.SPRUCE_SWIZZLE), null);
                    }
                    case BIRCH: {
                        return new Template.BlockInfo(blockInfo.field_186242_a, StructureWoodVariant.modifyBlockWithType(state, this.BIRCH_SWIZZLE), null);
                    }
                }
            }
            return blockInfo;
        }
    }

    private static enum BasementType {
        STUDY(TwilightForestMod.prefix("landscape/druid_hut/basement_study"), TwilightForestMod.prefix("landscape/druid_hut/basement_study_trap")),
        SHELVES(TwilightForestMod.prefix("landscape/druid_hut/basement_shelves"), TwilightForestMod.prefix("landscape/druid_hut/basement_shelves_trap")),
        GALLERY(TwilightForestMod.prefix("landscape/druid_hut/basement_gallery"), TwilightForestMod.prefix("landscape/druid_hut/basement_gallery_trap"));

        private final ResourceLocation RL;
        private final ResourceLocation RL_TRAP;
        private static int size;

        private BasementType(ResourceLocation rl, ResourceLocation rlTrap) {
            this.RL = rl;
            this.RL_TRAP = rlTrap;
            BasementType.increment();
        }

        private static void increment() {
            ++size;
        }

        private ResourceLocation getBasement(boolean trapped) {
            return trapped ? this.RL_TRAP : this.RL;
        }
    }

    private static enum HutType {
        REGULAR(TwilightForestMod.prefix("landscape/druid_hut/druid_hut")),
        SIDEWAYS(TwilightForestMod.prefix("landscape/druid_hut/druid_sideways")),
        DOUBLE_DECK(TwilightForestMod.prefix("landscape/druid_hut/druid_doubledeck"));

        private final ResourceLocation RL;
        private static int size;

        private HutType(ResourceLocation rl) {
            this.RL = rl;
            HutType.increment();
        }

        private static void increment() {
            ++size;
        }
    }
}

