/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;

public class ItemCollectionRegistry<E> {
    private Map<Item, Collection<E>> registry = new HashMap<Item, Collection<E>>();

    public void register(Item item, E entry) {
        Collection list = this.registry.computeIfAbsent(item, k -> new TreeSet());
        list.add(entry);
    }

    public Collection<E> getEntries(Item item) {
        return this.registry.get(item);
    }

    public void remove(Item item) {
        this.registry.remove(item);
    }

    public void clear(Item item) {
        Collection<E> list = this.registry.get(item);
        if (list != null) {
            list.clear();
        }
    }

    public void clear() {
        for (Map.Entry<Item, Collection<E>> map : this.registry.entrySet()) {
            map.getValue().clear();
        }
    }

    public Set<Map.Entry<Item, Collection<E>>> entrySet() {
        return this.registry.entrySet();
    }
}

