/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.log;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.forge.event.KeyEventHandler;
import journeymap.client.service.webmap.Webmap;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.StringUtil;
import org.apache.logging.log4j.Level;

public class ChatLog {
    static final List<TranslatableComponent> announcements = Collections.synchronizedList(new LinkedList());
    public static boolean enableAnnounceMod = false;
    private static boolean initialized = false;

    public static void queueAnnouncement(Component chat) {
        TranslatableComponent wrap = new TranslatableComponent("jm.common.chat_announcement", new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        TextComponent chat = Constants.getStringTextComponent(message);
        chat.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
        chat.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Constants.getStringTextComponent(url))));
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceFile(String message, File file) {
        TextComponent chat = Constants.getStringTextComponent(message);
        try {
            String path = file.getCanonicalPath();
            chat.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path)));
            chat.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Constants.getStringTextComponent(path))));
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        TextComponent chat = Constants.getStringTextComponent(text);
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement((Component)chat);
    }

    public static void showChatAnnouncements(Minecraft mc) {
        if (!initialized) {
            enableAnnounceMod = JourneymapClient.getInstance().getCoreProperties().announceMod.get();
            ChatLog.announceMod(enableAnnounceMod);
            VersionCheck.getVersionIsCurrent();
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Level logLevel;
            TranslatableComponent message = announcements.remove(0);
            if (message == null) continue;
            try {
                mc.f_91065_.m_93076_().m_93785_((Component)message);
            }
            catch (Exception e) {
                try {
                    Journeymap.getLogger().error("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = message.m_131329_()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                    Journeymap.getLogger().log(logLevel2, StringUtil.m_14406_((String)message.m_6111_()));
                    throw throwable;
                }
                logLevel = message.m_131329_()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                Journeymap.getLogger().log(logLevel, StringUtil.m_14406_((String)message.m_6111_()));
                continue;
            }
            logLevel = message.m_131329_()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
            Journeymap.getLogger().log(logLevel, StringUtil.m_14406_((String)message.m_6111_()));
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod || forced) {
            String keyName = KeyEventHandler.getInstance().kbFullscreenToggle.m_90863_().getString().toUpperCase();
            if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue()) {
                try {
                    Webmap webServer = JourneymapClient.getInstance().getJmServer();
                    String port = webServer.getPort() == 80 ? "" : ":" + webServer.getPort();
                    String message = Constants.getString("jm.common.webserver_and_mapgui_ready", keyName, port);
                    ChatLog.announceURL(message, "http://localhost" + port);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Couldn't check webserver: " + LogFormatter.toString(t));
                }
            } else {
                ChatLog.announceI18N("jm.common.mapgui_only_ready", keyName);
            }
            if (!JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            }
            enableAnnounceMod = false;
        }
    }

    private static class ErrorChat
    extends TextComponent {
        public ErrorChat(String text) {
            super(text);
        }
    }
}

