/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import journeymap.client.Constants;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import org.apache.commons.lang3.StringUtils;

public class WaypointParser {
    public static String[] QUOTES = new String[]{"'", "\""};
    public static Pattern PATTERN = Pattern.compile("(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+,\\s*)+(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+)", 2);
    private static Pattern TEXT_BETWEEN_QUOTES = Pattern.compile("\".*?\"|'.*?'|`.*`");

    public static List<String> getWaypointStrings(String line) {
        ArrayList<CallSite> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                if (!PATTERN.matcher(candidate).find() || WaypointParser.parse(candidate) == null) continue;
                if (list == null) {
                    list = new ArrayList<CallSite>(1);
                }
                list.add((CallSite)((Object)("[" + candidate + "]")));
            }
        }
        return list;
    }

    public static List<Waypoint> getWaypoints(String line) {
        ArrayList<Waypoint> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                Waypoint waypoint;
                if (!PATTERN.matcher(candidate).find() || (waypoint = WaypointParser.parse(candidate)) == null) continue;
                if (list == null) {
                    list = new ArrayList<Waypoint>(1);
                }
                list.add(waypoint);
            }
        }
        return list;
    }

    public static Waypoint parse(String original) {
        String[] quotedVals = null;
        String raw = original.replaceAll("[\\[\\]]", "");
        for (String quoteChar : QUOTES) {
            if (!raw.contains(quoteChar) || (quotedVals = StringUtils.substringsBetween((String)raw, (String)quoteChar, (String)quoteChar)) == null) continue;
            for (int i = 0; i < quotedVals.length; ++i) {
                raw = raw.replaceAll(TEXT_BETWEEN_QUOTES.pattern(), "__TEMP_" + i);
            }
        }
        Integer x = null;
        Integer y = 63;
        Integer z = null;
        String dim = null;
        String name = null;
        boolean showDeviation = false;
        for (String part : raw.split(",")) {
            String[] prop;
            if (!part.contains(":") || (prop = part.split(":")).length != 2) continue;
            String key = prop[0].trim().toLowerCase();
            String val = prop[1].trim();
            try {
                if ("x".equals(key)) {
                    x = Integer.parseInt(val);
                } else if ("y".equals(key)) {
                    y = Integer.parseInt(val);
                } else if ("z".equals(key)) {
                    z = Integer.parseInt(val);
                } else if ("dim".equals(key)) {
                    dim = val;
                } else if ("name".equals(key)) {
                    name = val;
                }
                if (!"showDeviation".equals(key)) continue;
                showDeviation = Boolean.parseBoolean(val);
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Bad format in waypoint text part: " + part + ": " + e);
            }
        }
        if (x != null && z != null) {
            if (name != null && quotedVals != null) {
                for (int i = 0; i < quotedVals.length; ++i) {
                    String val = quotedVals[i];
                    name = name.replaceAll("__TEMP_" + i, val);
                }
            }
            if (name == null) {
                name = String.format("%s,%s", x, z);
            }
            Random r = new Random();
            if (dim == null) {
                dim = Minecraft.m_91087_().f_91073_ == null ? "minecraft:overwrold" : DimensionHelper.getDimKeyName((ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_());
            }
            Waypoint waypoint = new Waypoint(name, new BlockPos(x.intValue(), y.intValue(), z.intValue()), new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255)), Waypoint.Type.Normal, dim, showDeviation);
            return waypoint;
        }
        return null;
    }

    public static void parseChatForWaypoints(ClientChatReceivedEvent event, String unformattedText) {
        List<String> matches = WaypointParser.getWaypointStrings(unformattedText);
        if (matches != null) {
            boolean changed = false;
            if (event.getMessage() instanceof TranslatableComponent) {
                Object[] formatArgs = ((TranslatableComponent)event.getMessage()).m_131329_();
                for (int i = 0; i < formatArgs.length && !matches.isEmpty(); ++i) {
                    Component result;
                    Object arg;
                    if (formatArgs[i] instanceof Component) {
                        arg = (Component)formatArgs[i];
                        result = WaypointParser.addWaypointMarkup(arg.m_6111_(), matches);
                        if (result == null) continue;
                        formatArgs[i] = result;
                        changed = true;
                        continue;
                    }
                    if (!(formatArgs[i] instanceof String) || (result = WaypointParser.addWaypointMarkup((String)(arg = (String)formatArgs[i]), matches)) == null) continue;
                    formatArgs[i] = result;
                    changed = true;
                }
                if (changed) {
                    event.setMessage((Component)new TranslatableComponent(((TranslatableComponent)event.getMessage()).m_131328_(), formatArgs));
                }
            } else if (event.getMessage() instanceof TextComponent) {
                Component result = WaypointParser.addWaypointMarkup(event.getMessage().getString(), matches);
                if (result != null) {
                    event.setMessage(result);
                    changed = true;
                }
            } else {
                Journeymap.getLogger().warn("No implementation for handling waypoints in ITextComponent " + event.getMessage().getClass());
            }
            if (!changed) {
                Journeymap.getLogger().warn(String.format("Matched waypoint in chat but failed to update message for %s : %s\n%s", event.getMessage().getClass(), event.getMessage().getString(), Component.Serializer.m_130703_((Component)event.getMessage())));
            }
        }
    }

    private static Component addWaypointMarkup(String text, List<String> matches) {
        ArrayList<TextComponent> newParts = new ArrayList<TextComponent>();
        int index = 0;
        boolean matched = false;
        Iterator<String> iterator2 = matches.iterator();
        while (iterator2.hasNext()) {
            String match = iterator2.next();
            if (!text.contains(match)) continue;
            int start = text.indexOf(match);
            if (start > index) {
                newParts.add(Constants.getStringTextComponent(text.substring(index, start)));
            }
            matched = true;
            TextComponent textComponent = Constants.getStringTextComponent(match);
            textComponent.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/jm wpedit " + match)));
            TextComponent hover = Constants.getStringTextComponent("JourneyMap: ");
            hover.m_130938_(style -> style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW)));
            TextComponent hover2 = Constants.getStringTextComponent("Click to create Waypoint.\nCtrl+Click to view on map.");
            hover2.m_130938_(style -> style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA)));
            hover.m_7220_((Component)hover2);
            textComponent.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hover)));
            textComponent.m_130938_(style -> style.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA)));
            newParts.add(textComponent);
            index = start + match.length();
            iterator2.remove();
        }
        if (!matched) {
            return null;
        }
        if (index < text.length() - 1) {
            newParts.add(Constants.getStringTextComponent(text.substring(index, text.length())));
        }
        if (!newParts.isEmpty()) {
            TextComponent replacement = Constants.getStringTextComponent("");
            for (Component component : newParts) {
                replacement.m_7220_(component);
            }
            return replacement;
        }
        return null;
    }
}

