/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class WaypointPacket {
    private String action;
    private String waypoint;
    private boolean announce;
    public static final ResourceLocation CHANNEL = new ResourceLocation("journeymap", "waypoint");

    public WaypointPacket(String waypoint, boolean announce, String action) {
        this.action = action;
        this.waypoint = waypoint;
        this.announce = announce;
    }

    public WaypointPacket(FriendlyByteBuf buf) {
        try {
            this.waypoint = buf.m_130277_();
            this.action = buf.m_130277_();
            this.announce = buf.readBoolean();
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for waypoint: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            buf.m_130070_(this.waypoint);
            buf.m_130070_(this.action);
            buf.writeBoolean(this.announce);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message for waypoint: " + t);
        }
    }

    public static void handle(WaypointPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                JourneymapClient.getInstance().getPacketHandler().onWaypointCreatePacket(packet.waypoint, packet.action, packet.announce);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

