/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightableLanternBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WallLanternTexturesRegistry {
    private static Set<Block> POSSIBLE_LANTERNS = null;
    public static final Map<Block, ResourceLocation> SPECIAL_TEXTURES = new HashMap<Block, ResourceLocation>();

    private static void init() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Block i : ForgeRegistries.BLOCKS) {
            if (!WallLanternTexturesRegistry.isLanternBlock(i)) continue;
            builder.add((Object)i);
        }
        POSSIBLE_LANTERNS = builder.build();
    }

    public static boolean isLanternBlock(Block b) {
        String namespace = b.getRegistryName().m_135827_();
        if (namespace.equals("skinnedlanterns")) {
            return true;
        }
        if (b instanceof LanternBlock) {
            return !b.m_49966_().m_155947_() || b instanceof LightableLanternBlock;
        }
        return false;
    }

    public static void onResourceReload(ResourceManager manager) {
        if (POSSIBLE_LANTERNS == null) {
            WallLanternTexturesRegistry.init();
        }
        SPECIAL_TEXTURES.clear();
        for (Block i : POSSIBLE_LANTERNS) {
            try {
                ResourceLocation reg2 = i.getRegistryName();
                Object namespace = reg2.m_135827_().equals("minecraft") || reg2.m_135827_().equals("supplementaries") ? "" : reg2.m_135827_() + "/";
                String s = "textures/blocks/wall_lanterns/" + (String)namespace + reg2.m_135815_() + ".json";
                ResourceLocation fullPath = Supplementaries.res(s);
                Resource resource = manager.m_142591_(fullPath);
                JsonObject bsElement = RPUtils.deserializeJson((InputStream)resource.m_6679_());
                String texture = RPUtils.findFirstResourceInJsonRecursive((JsonElement)bsElement);
                if (texture.isEmpty()) continue;
                SPECIAL_TEXTURES.put(i, new ResourceLocation(texture));
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public static TextureAtlasSprite getTextureForLantern(Block block2) {
        ResourceLocation res = SPECIAL_TEXTURES.get(block2);
        if (res == null) {
            return null;
        }
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(res);
    }
}

