/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui.widgets;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.client.gui.widgets.MultiLineEditBoxWidget;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.StatueBlockTileRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.Nullable;

public class PlayerSuggestionBoxWidget
extends MultiLineEditBoxWidget {
    public static Map<UUID, String> USERNAME_CACHE = new HashMap<UUID, String>();
    private static final Component EMPTY_SEARCH = new TranslatableComponent("gui.supplementaries.present.send").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC);
    private final List<SimplePlayerEntry> allPlayers = new ArrayList<SimplePlayerEntry>();
    private final List<SimplePlayerEntry> filtered = new ArrayList<SimplePlayerEntry>();
    private SimplePlayerEntry selectedPlayer = null;
    @Nullable
    private String suggestion;
    private String fullSuggestion = "";

    public PlayerSuggestionBoxWidget(Minecraft mc, int x, int y, int width, int height) {
        super(mc, x, y, width, height);
        Collection onlinePlayers = mc.f_91074_.f_108617_.m_105143_();
        for (UUID uUID : onlinePlayers) {
            PlayerInfo playerinfo = mc.f_91074_.f_108617_.m_104949_(uUID);
            if (playerinfo == null) continue;
            this.allPlayers.add(new SimplePlayerEntry(playerinfo));
        }
        for (Map.Entry entry : USERNAME_CACHE.entrySet()) {
            if (onlinePlayers.contains(entry.getKey())) continue;
            this.allPlayers.add(new SimplePlayerEntry((UUID)entry.getKey(), (String)entry.getValue()));
        }
        this.filtered.addAll(this.allPlayers);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.f_93624_) {
            if (this.canConsumeInput() && this.suggestion != null) {
                int x = this.f_93620_;
                MultiLineEditBoxWidget.DisplayCache cache = this.getDisplayCache();
                if (cache.lines.length > 0) {
                    x += this.font.m_92895_(cache.lines[0].contents);
                }
                this.font.m_92883_(poseStack, this.suggestion, (float)x, (float)this.f_93621_, -8355712);
            }
            if (this.getText().isEmpty()) {
                this.font.m_92889_(poseStack, EMPTY_SEARCH, (float)this.f_93620_, (float)this.f_93621_, 0);
            } else if (this.selectedPlayer != null) {
                this.selectedPlayer.render(poseStack, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, partialTicks);
            }
        }
    }

    @Override
    public boolean m_7933_(int key, int p_94133_, int p_94134_) {
        if (key == 258 && this.canConsumeInput()) {
            if (!this.fullSuggestion.isEmpty()) {
                this.setText(this.fullSuggestion);
                this.moveCursorToEnd();
                this.clearDisplayCache();
            }
            return true;
        }
        return super.m_7933_(key, p_94133_, p_94134_);
    }

    @Override
    public void onValueChanged() {
        this.updateFilteredEntries();
        String newValue = this.getText();
        this.selectedPlayer = null;
        String suggestion = "";
        this.fullSuggestion = "";
        if (!newValue.isEmpty()) {
            for (SimplePlayerEntry entry : this.filtered) {
                String name = entry.getName();
                if (this.fullSuggestion.isEmpty()) {
                    this.fullSuggestion = name;
                    suggestion = name.substring(newValue.length());
                }
                if (!name.equalsIgnoreCase(newValue)) continue;
                this.selectedPlayer = entry;
                break;
            }
        }
        this.setSuggestion(suggestion);
    }

    private void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    public void setState(boolean hasItem, boolean packed) {
        super.setState(hasItem, packed);
        this.filtered.clear();
        if (!packed && hasItem) {
            this.m_93692_(true);
            this.filtered.addAll(this.allPlayers);
        }
    }

    private void updateFilteredEntries() {
        String filter = this.getText();
        filter = filter == null ? "" : filter.toLowerCase(Locale.ROOT);
        this.filtered.clear();
        String finalFilter = filter;
        this.filtered.addAll(this.allPlayers.stream().filter(s -> s.getName().toLowerCase(Locale.ROOT).startsWith(finalFilter)).toList());
    }

    public void addPlayer(PlayerInfo info) {
        this.allPlayers.removeIf(simplePlayerEntry -> simplePlayerEntry.getId().equals(info.m_105312_().getId()));
        this.allPlayers.add(new SimplePlayerEntry(info));
        this.updateFilteredEntries();
        this.onValueChanged();
    }

    public void removePlayer(UUID id) {
        for (SimplePlayerEntry simplePlayerEntry : this.allPlayers) {
            if (!simplePlayerEntry.getId().equals(id)) continue;
            simplePlayerEntry.setOnline(false);
            return;
        }
    }

    public static class SimplePlayerEntry {
        private static final int SKIN_SIZE = 8;
        private final Supplier<ResourceLocation> skinGetter;
        private GameProfile profile;
        private boolean isOnline;

        public SimplePlayerEntry(PlayerInfo playerInfo) {
            this.profile = playerInfo.m_105312_();
            this.skinGetter = () -> ((PlayerInfo)playerInfo).m_105337_();
            this.isOnline = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SimplePlayerEntry(UUID id, String lastName) {
            GameProfile profile = new GameProfile(id, lastName);
            this.skinGetter = () -> StatueBlockTileRenderer.getPlayerSkin(this.profile);
            if (!profile.isComplete() || !profile.getProperties().containsKey((Object)"textures")) {
                SimplePlayerEntry simplePlayerEntry = this;
                synchronized (simplePlayerEntry) {
                    this.profile = profile;
                }
                SkullBlockEntity.m_155738_((GameProfile)this.profile, gameProfile -> {
                    this.profile = gameProfile;
                });
            }
            this.isOnline = false;
        }

        public void setOnline(boolean online) {
            this.isOnline = online;
        }

        public UUID getId() {
            return this.profile.getId();
        }

        public String getName() {
            return this.profile.getName();
        }

        public void render(PoseStack poseStack, int x, int y, int width, int height, float pPartialTicks) {
            int i = x + width - 4;
            float c = this.isOnline ? 1.0f : 0.5f;
            RenderSystem.m_157429_((float)1.0f, (float)c, (float)c, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.skinGetter.get());
            GuiComponent.m_93160_((PoseStack)poseStack, (int)i, (int)y, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69478_();
            GuiComponent.m_93160_((PoseStack)poseStack, (int)i, (int)y, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69461_();
        }
    }
}

