/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.mehvahdjukaar.supplementaries.common.utils.VectorUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class RotationTrailParticle
extends SimpleAnimatedParticle {
    public static final float SPEED = 11.0f;
    public static final int LIFE = 8;
    private final Vec3 axis;
    private final Vec3 origin;
    private final double radius;
    private float angularVelocity;
    private float currentAngle;
    private float fadeR;
    private float fadeG;
    private float fadeB;
    private static final float al = 0.6f;

    private RotationTrailParticle(ClientLevel clientWorld, double x, double y, double z, Vec3 center, Vec3 rotationAxis, int ccw, double radius, double angle, SpriteSet sprite) {
        super(clientWorld, x, y, z, sprite, -5.0E-4f);
        this.origin = center;
        this.axis = rotationAxis;
        this.angularVelocity = (float)((double)((float)ccw * 11.0f) * Math.PI / 180.0);
        this.radius = radius;
        this.currentAngle = (float)angle;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.m_107250_(0.01f, 0.01f);
        this.f_107663_ *= 0.625f;
        this.f_107225_ = 8;
        this.m_107657_(ClientConfigs.cached.TURN_PARTICLE_COLOR);
        this.m_107659_(ClientConfigs.cached.TURN_PARTICLE_FADE_COLOR);
        this.m_108339_(sprite);
        this.f_107230_ = 0.6f;
        this.f_107219_ = false;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_107271_(0.6f - (float)this.f_107224_ / (float)this.f_107225_ * 0.6f * 0.7f);
    }

    public void m_107659_(int pRgb) {
        this.fadeR = (float)((pRgb & 0xFF0000) >> 16) / 255.0f;
        this.fadeG = (float)((pRgb & 0xFF00) >> 8) / 255.0f;
        this.fadeB = (float)(pRgb & 0xFF) / 255.0f;
        super.m_107659_(pRgb);
    }

    public void m_6257_(double x, double y, double z) {
        this.f_107227_ += (this.fadeR - this.f_107227_) * 0.1f;
        this.f_107228_ += (this.fadeG - this.f_107228_) * 0.1f;
        this.f_107229_ += (this.fadeB - this.f_107229_) * 0.1f;
        this.currentAngle += this.angularVelocity;
        Vec3 rot = new Vec3(this.radius, 0.0, 0.0).m_82524_(this.currentAngle);
        Vec3 newPos = VectorUtils.changeBasisN(this.axis, rot).m_82549_(this.origin);
        this.angularVelocity = (float)((double)this.angularVelocity * 0.75);
        super.m_6257_(newPos.f_82479_ - this.f_107212_, newPos.f_82480_ - this.f_107213_, newPos.f_82481_ - this.f_107214_);
    }

    public static float increment(float age, int step) {
        return 11.0f * (float)step * (1.0f - ((float)step + 2.0f * (age - 1.0f)) / 16.0f);
    }

    public int m_6355_(float pPartialTick) {
        BlockPos blockpos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_);
        return this.f_107208_.m_46805_(blockpos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)blockpos) : 0;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double direction, double radius, double initialAngle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (direction < 0.0) {
                ccw = -1;
                direction = -direction;
            }
            Direction dir = Direction.m_122376_((int)((int)direction));
            float radAngle = (float)(initialAngle * Math.PI / 180.0);
            Vec3 axis = VectorUtils.ItoD(dir.m_122436_());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).m_82524_(radAngle);
            Vec3 newPos = VectorUtils.changeBasisN(axis, rot).m_82549_(center);
            return new RotationTrailParticle(world, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_, center, axis, ccw, radius, radAngle, this.sprites);
        }
    }
}

