/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.color;

import java.util.Random;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ColorHelper {
    private static final float[][] SOAP_COLORS;

    public static int pack(float[] rgb) {
        return FastColor.ARGB32.m_13660_((int)255, (int)((int)(rgb[0] * 255.0f)), (int)((int)(rgb[1] * 255.0f)), (int)((int)(rgb[2] * 255.0f)));
    }

    public static float oneToOneSaturation(float saturation, float lightness) {
        float c = 1.0f - Math.abs(2.0f * lightness - 1.0f);
        return Math.min(saturation, c);
    }

    public static int getRainbowColorPost(float division) {
        float scale = 3600.0f / division;
        float h = (float)((int)(System.currentTimeMillis() % (long)((int)scale))) / scale;
        float[] hsl = ColorHelper.prettyfyColor(new float[]{h, 0.6f, 0.5f});
        return ColorHelper.hslToRgb(hsl[0], hsl[1], hsl[2]);
    }

    public static int getRandomBrightColor(Random random) {
        float h = random.nextFloat();
        float[] hsl = ColorHelper.prettyfyColor(new float[]{h, 0.62f + random.nextFloat() * 0.3f, 0.43f + random.nextFloat() * 0.15f});
        return ColorHelper.hslToRgb(hsl[0], hsl[1], hsl[2]);
    }

    public static int getRainbowColor(float division) {
        float scale = 3600.0f / division;
        float h = (float)((int)(System.currentTimeMillis() % (long)((int)scale))) / scale;
        return ColorHelper.hslToRgb(h, 0.6f, 0.5f);
    }

    public static float[] getBubbleColor(float phase) {
        int n = SOAP_COLORS.length;
        int ind = (int)Math.floor((float)n * phase);
        float delta = (float)n * phase % 1.0f;
        float[] start = SOAP_COLORS[ind];
        float[] end = SOAP_COLORS[(ind + 1) % n];
        float red = Mth.m_14179_((float)delta, (float)start[0], (float)end[0]);
        float green = Mth.m_14179_((float)delta, (float)start[1], (float)end[1]);
        float blue = Mth.m_14179_((float)delta, (float)start[2], (float)end[2]);
        return new float[]{red, green, blue};
    }

    public static float[] prettyfyColor(float[] hsl) {
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        s = ColorHelper.oneToOneSaturation(s, l);
        float minLightness = 0.47f;
        l = Math.max(l, minLightness);
        float j = 1.0f - l;
        float ratio = 0.35f;
        if (s < j) {
            s = ratio * j + (1.0f - ratio) * s;
        }
        float scaling = 0.15f;
        float angle = 90.0f;
        float n = (float)((double)scaling * Math.exp((double)(-angle) * Math.pow(h - 0.6666f, 2.0)));
        return new float[]{h, s -= n, l};
    }

    public static int hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = ColorHelper.hueToRgb(p, q, h + 0.33333334f);
            g = ColorHelper.hueToRgb(p, q, h);
            b = ColorHelper.hueToRgb(p, q, h - 0.33333334f);
        }
        return FastColor.ARGB32.m_13660_((int)Mth.m_14143_((float)255.0f), (int)Mth.m_14143_((float)(r * 255.0f)), (int)Mth.m_14143_((float)(g * 255.0f)), (int)Mth.m_14143_((float)(b * 255.0f)));
    }

    public static int to255(float v) {
        return (int)Math.min(255.0f, 256.0f * v);
    }

    public static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public static float[] rgbToHsl(int rgb) {
        int r = FastColor.ARGB32.m_13665_((int)rgb);
        int g = FastColor.ARGB32.m_13667_((int)rgb);
        int b = FastColor.ARGB32.m_13669_((int)rgb);
        return ColorHelper.rgbToHsl(r, g, b);
    }

    public static float[] rgbToHsl(int pR, int pG, int pB) {
        float h;
        float s;
        float r = (float)pR / 255.0f;
        float g = (float)pG / 255.0f;
        float b = (float)pB / 255.0f;
        float max = r > g && r > b ? r : Math.max(g, b);
        float min = r < g && r < b ? r : Math.min(g, b);
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            h = r > g && r > b ? (g - b) / d + (g < b ? 6.0f : 0.0f) : (g > b ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            h /= 6.0f;
        }
        return new float[]{h, s, l};
    }

    public static float[] fromRGB(int rgb) {
        float r = (float)FastColor.ARGB32.m_13665_((int)rgb) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)rgb) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)rgb) / 255.0f;
        return ColorHelper.fromRGB(r, g, b);
    }

    public static float[] fromRGB(float r, float g, float b) {
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max == min) {
            h = 0.0f;
        } else if (max == r) {
            h = (60.0f * (g - b) / (max - min) + 360.0f) % 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        float l = (max + min) / 2.0f;
        float s = 0.0f;
        s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        return new float[]{h, s * 100.0f, l * 100.0f};
    }

    public static int toRGB(float h, float s, float l) {
        return ColorHelper.toRGB(h, s, l, 1.0f);
    }

    public static int toRGB(float h, float s, float l, float alpha) {
        s = Mth.m_14036_((float)s, (float)0.0f, (float)100.0f);
        l = Mth.m_14036_((float)l, (float)0.0f, (float)100.0f);
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, ColorHelper.HueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, ColorHelper.HueToRGB(p, q, h));
        float b = Math.max(0.0f, ColorHelper.HueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return FastColor.ARGB32.m_13660_((int)Mth.m_14143_((float)(alpha * 255.0f)), (int)Mth.m_14143_((float)(r * 255.0f)), (int)Mth.m_14143_((float)(g * 255.0f)), (int)Mth.m_14143_((float)(b * 255.0f)));
    }

    private static float HueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    static {
        int[] c = new int[]{13870327, 15974896, 13870327, 10666232, 10680543, 10666232};
        float[][] temp = new float[c.length][];
        for (int i = 0; i < c.length; ++i) {
            int j = c[i];
            temp[i] = new float[]{(float)FastColor.ARGB32.m_13665_((int)j) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)j) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)j) / 255.0f};
        }
        SOAP_COLORS = temp;
    }
}

