/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.client.block_models.StatueEntityModel;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.PedestalBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.common.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.StatueBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class StatueBlockTileRenderer
implements BlockEntityRenderer<StatueBlockTile> {
    protected final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private final StatueEntityModel model;
    private final BlockRenderDispatcher blockRenderer;
    private final EntityRenderDispatcher entityRenderer;
    private boolean slim = false;

    public StatueBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new StatueEntityModel(context);
        this.blockRenderer = Minecraft.m_91087_().m_91289_();
        this.entityRenderer = Minecraft.m_91087_().m_91290_();
    }

    protected boolean canRenderName(StatueBlockTile tile) {
        BlockPos hitPos;
        BlockPos pos;
        HitResult hit;
        if (Minecraft.m_91404_() && tile.owner != null && (hit = Minecraft.m_91087_().f_91077_) != null && hit.m_6662_() == HitResult.Type.BLOCK && (pos = tile.m_58899_()).equals((Object)(hitPos = new BlockPos(hit.m_82450_())))) {
            double d0 = this.entityRenderer.m_114378_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            return d0 < 256.0;
        }
        return false;
    }

    public int m_142163_() {
        return 60;
    }

    public static ResourceLocation getPlayerSkin(GameProfile gameProfile) {
        return StatueBlockTileRenderer.getPlayerSkinAndSlim(gameProfile, s -> {});
    }

    public static ResourceLocation getPlayerSkinAndSlim(GameProfile gameProfile, Consumer<Boolean> slimSkinSetter) {
        if (!gameProfile.isComplete()) {
            return new ResourceLocation("minecraft:textures/entity/steve.png");
        }
        SkinManager skinManager = Minecraft.m_91087_().m_91109_();
        Map skinCache = skinManager.m_118815_(gameProfile);
        if (skinCache.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture texture = (MinecraftProfileTexture)skinCache.get(MinecraftProfileTexture.Type.SKIN);
            String s = texture.getMetadata("model");
            boolean slim = s != null && !s.equals("default");
            slimSkinSetter.accept(slim);
            return skinManager.m_118825_(texture, MinecraftProfileTexture.Type.SKIN);
        }
        slimSkinSetter.accept(false);
        return DefaultPlayerSkin.m_118627_((UUID)gameProfile.getId());
    }

    private boolean isSkinSlim(GameProfile gameProfile) {
        return gameProfile != null && gameProfile.getId() != null && (gameProfile.getId().hashCode() & 1) == 1;
    }

    public void render(StatueBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        String name;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        GameProfile playerInfo = tile.owner;
        if (this.canRenderName(tile) && (name = tile.owner.getName()) != null) {
            PedestalBlockTileRenderer.renderName((Component)new TextComponent(name), 0.875f, matrixStackIn, bufferIn, combinedLightIn);
        }
        ResourceLocation resourceLocation = tile.owner == null ? Textures.STATUE : StatueBlockTileRenderer.getPlayerSkinAndSlim(playerInfo, s -> {
            this.slim = s;
        });
        Direction dir = tile.getDirection();
        matrixStackIn.m_85845_(RotHlpr.rot(dir));
        matrixStackIn.m_85845_(RotHlpr.X90);
        matrixStackIn.m_85837_(0.0, -0.25, 0.0);
        RenderType renderType = RenderType.m_110473_((ResourceLocation)resourceLocation);
        StatueBlockTile.StatuePose pose = tile.pose;
        ItemStack stack = tile.getDisplayedItem();
        if (CommonUtil.FESTIVITY.isHalloween()) {
            this.model.head.f_104207_ = false;
            this.model.hat.f_104207_ = false;
            if (pose == StatueBlockTile.StatuePose.STANDING) {
                pose = StatueBlockTile.StatuePose.HOLDING;
                stack = Items.f_42055_.m_7968_();
            } else {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85841_(-0.625f, -0.625f, 0.625f);
                matrixStackIn.m_85837_(0.0, 0.1875, 0.0);
                this.itemRenderer.m_174269_(Items.f_42047_.m_7968_(), ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, 0);
                matrixStackIn.m_85849_();
            }
        } else {
            this.model.head.f_104207_ = true;
            this.model.hat.f_104207_ = true;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(0.5f, 0.499f, 0.5f);
        VertexConsumer buffer = bufferIn.m_6299_(renderType);
        this.model.setupAnim(tile.m_58904_().m_46467_(), partialTicks, dir, pose, tile.isWaving, this.slim);
        this.model.m_7695_(matrixStackIn, buffer, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        this.slim = false;
        switch (pose) {
            case STANDING: {
                break;
            }
            case CANDLE: {
                matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
                matrixStackIn.m_85837_(-0.5, -0.6875, -0.3125);
                this.blockRenderer.renderSingleBlock(tile.candle, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
                break;
            }
            default: {
                matrixStackIn.m_85841_(-0.5f, -0.5f, 0.5f);
                BakedModel model = this.itemRenderer.m_174264_(stack, tile.m_58904_(), null, 0);
                if (pose == StatueBlockTile.StatuePose.SWORD) {
                    matrixStackIn.m_85837_(-0.35, -1.0625, 0.0);
                    matrixStackIn.m_85845_(RotHlpr.Z135);
                } else if (pose == StatueBlockTile.StatuePose.TOOL) {
                    matrixStackIn.m_85837_(-0.4, -1.25, 0.0);
                    matrixStackIn.m_85845_(RotHlpr.Z135);
                }
                matrixStackIn.m_85837_(0.0, -0.5, -0.5);
                if (pose.isGlobe()) {
                    if (ClientRegistry.GLOBE_RENDERER_INSTANCE == null) break;
                    boolean sepia = pose == StatueBlockTile.StatuePose.SEPIA_GLOBE;
                    Pair<GlobeBlockTile.GlobeModel, ResourceLocation> pair = stack.m_41788_() ? GlobeBlockTile.GlobeType.getGlobeTexture(stack.m_41786_().getString()) : Pair.of((Object)((Object)GlobeBlockTile.GlobeModel.GLOBE), null);
                    ClientRegistry.GLOBE_RENDERER_INSTANCE.renderGlobe(pair, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, sepia, tile.m_58904_());
                    break;
                }
                this.itemRenderer.m_115143_(stack, ItemTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, model);
            }
        }
        matrixStackIn.m_85849_();
    }
}

