/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BubbleBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BubbleBlock
extends Block
implements EntityBlock {
    public BubbleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext placeContext) {
        return !placeContext.m_7078_();
    }

    public boolean m_5568_() {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos p_60557_, CollisionContext collisionContext) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext ec;
        if (collisionContext.m_6513_(Shapes.m_83144_(), pos, false) && collisionContext instanceof EntityCollisionContext && (ec = (EntityCollisionContext)collisionContext).m_193113_() instanceof LivingEntity) {
            return Shapes.m_83144_();
        }
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity2) {
        if (ServerConfigs.cached.BUBBLE_BREAK && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BubbleBlock.breakBubble(serverLevel, pos);
        }
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        BubbleBlock.makeParticle(pos, level);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity2, int numberOfParticles) {
        return true;
    }

    public static void makeParticle(BlockPos pos, Level level) {
        level.m_7106_((ParticleOptions)ModRegistry.BUBBLE_BLOCK_PARTICLE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
    }

    public static void sendParticles(BlockPos pos, ServerLevel level) {
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModRegistry.BUBBLE_BLOCK_PARTICLE.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static void breakBubble(ServerLevel level, BlockPos pos) {
        level.m_7471_(pos, false);
        BubbleBlock.sendParticles(pos, level);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity2) {
        if (ServerConfigs.cached.BUBBLE_BREAK) {
            level.m_186460_(pos, (Block)this, 5);
        }
        super.m_141947_(level, pos, state, entity2);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity p_152429_, float v) {
        super.m_142072_(level, state, pos, p_152429_, v);
        if (!level.f_46443_ && ServerConfigs.cached.BUBBLE_BREAK) {
            if (v > 3.0f) {
                BubbleBlock.breakBubble((ServerLevel)level, pos);
            } else {
                level.m_186460_(pos, (Block)this, (int)Mth.m_14036_((float)(7.0f - v / 2.0f), (float)1.0f, (float)5.0f));
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel serverLevel, BlockPos pos, Random random) {
        BubbleBlock.breakBubble(serverLevel, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BubbleBlockTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState state, BlockEntityType<T> tBlockEntityType) {
        return BlockUtils.getTicker(tBlockEntityType, (BlockEntityType)ModRegistry.BUBBLE_BLOCK_TILE.get(), BubbleBlockTile::tick);
    }
}

