/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.UrnBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.common.entities.FallingUrnEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class UrnBlock
extends FallingBlock
implements EntityBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty TREASURE = BlockProperties.TREASURE;
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)UrnBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape[])new VoxelShape[]{UrnBlock.m_49796_((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), UrnBlock.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)});

    public UrnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TREASURE, (Comparable)Boolean.valueOf(false)));
    }

    public int m_6248_(BlockState state, BlockGetter reader, BlockPos pos) {
        return 6173722;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_()) {
            worldIn.m_186460_(pos, (Block)this, this.m_7198_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, TREASURE});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader pLevel, BlockPos pos) {
        return UrnBlock.m_49863_((LevelReader)pLevel, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            if (worldIn instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)worldIn;
                this.m_7458_(stateIn, serverLevel, currentPos, worldIn.m_5822_());
            }
            return stateIn;
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_7458_(BlockState state, ServerLevel pLevel, BlockPos pos, Random pRand) {
        if (UrnBlock.m_53241_((BlockState)pLevel.m_8055_(pos.m_7495_())) && pos.m_123342_() >= pLevel.m_141937_()) {
            CompoundTag tag = null;
            BlockEntity blockEntity = pLevel.m_7702_(pos);
            if (blockEntity instanceof UrnBlockTile) {
                UrnBlockTile tile = (UrnBlockTile)blockEntity;
                tag = tile.m_187482_();
                tile.m_6211_();
                tile.m_7651_();
            }
            FallingUrnEntity fallingblockentity = FallingUrnEntity.fall((Level)pLevel, pos, state);
            fallingblockentity.f_31944_ = tag;
            this.m_6788_(fallingblockentity);
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (!((Boolean)pState.m_61143_((Property)TREASURE)).booleanValue()) {
            return new UrnBlockTile(pPos, pState);
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemDisplayTile tile;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ItemDisplayTile && (tile = (ItemDisplayTile)blockEntity).m_7983_()) {
            return tile.interact(player, handIn);
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof UrnBlockTile) {
                UrnBlockTile tile = (UrnBlockTile)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        Container tile;
        BlockEntity blockEntity;
        if (((Boolean)blockState.m_61143_((Property)TREASURE)).booleanValue() || (blockEntity = world.m_7702_(pos)) instanceof Container && !(tile = (Container)blockEntity).m_7983_()) {
            return 15;
        }
        return 0;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity2, ItemStack stack) {
        super.m_6402_(world, pos, state, entity2, stack);
        BlockUtils.addOptionalOwnership(entity2, world, pos);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof UrnBlockTile) {
            UrnBlockTile tile = (UrnBlockTile)((Object)object);
            ArrayList<ItemStack> l = new ArrayList<ItemStack>();
            for (int i = 0; i < tile.m_6643_(); ++i) {
                l.add(tile.m_8020_(i));
            }
            return l;
        }
        ResourceLocation resourcelocation = this.m_60589_();
        if (resourcelocation == BuiltInLootTables.f_78712_) {
            return super.m_7381_(state, builder);
        }
        LootContext lootcontext = builder.m_78972_(LootContextParams.f_81461_, (Object)state).m_78975_(LootContextParamSets.f_81421_);
        float oldLuck = lootcontext.m_78945_();
        LootContext.Builder newBuilder = new LootContext.Builder(lootcontext);
        ItemStack stack = (ItemStack)builder.m_78982_(LootContextParams.f_81463_);
        int f = stack == null ? 0 : EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
        newBuilder.m_78963_(oldLuck + 0.25f * (float)f);
        lootcontext = newBuilder.m_78972_(LootContextParams.f_81461_, (Object)state).m_78975_(LootContextParamSets.f_81421_);
        ServerLevel serverlevel = lootcontext.m_78952_();
        LootTable loottable = serverlevel.m_142572_().m_129898_().m_79217_(resourcelocation);
        return loottable.m_79129_(lootcontext);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (pLevel.f_46443_ && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pPlayer.m_21211_()) == 0) {
            UrnBlock.spawnExtraBrokenParticles(pState, pPos, pLevel);
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
    }

    public static void spawnExtraBrokenParticles(BlockState state, BlockPos pos, Level level) {
        if (level.f_46443_ && ((Boolean)state.m_61143_((Property)TREASURE)).booleanValue()) {
            level.m_142052_(pos, state);
            if (level.f_46441_.nextInt(20) == 0) {
                double x = (double)pos.m_123341_() + 0.5;
                double y = (double)pos.m_123342_() + 0.3125;
                double z = (double)pos.m_123343_() + 0.5;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 0.0, 0.05, 0.0);
                float f = level.f_46441_.nextFloat() * 0.4f + level.f_46441_.nextFloat() > 0.9f ? 0.6f : 0.0f;
                level.m_6263_(null, x, y, z, SoundEvents.f_12404_, SoundSource.BLOCKS, f, 0.6f + level.f_46441_.nextFloat() * 0.4f);
            }
        }
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        super.m_5581_(pLevel, pState, pHit, pProjectile);
        BlockPos pos = pHit.m_82425_();
        pLevel.m_46961_(pos, true);
        UrnBlock.spawnExtraBrokenParticles(pState, pos, pLevel);
    }
}

