/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.IDynamicContainer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.block.util.IColored;
import net.mehvahdjukaar.supplementaries.common.inventories.PresentContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class PresentBlockTile
extends OpeneableContainerBlockEntity
implements IColored,
IDynamicContainer {
    public static final String PUBLIC_KEY = "@e";
    private String recipient = "";
    private String sender = "";
    private String description = "";

    public PresentBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.PRESENT_TILE.get(), pos, state, 1);
    }

    @Override
    public boolean canHoldItems() {
        return this.isPacked();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nullable
    public DyeColor getColor() {
        return ((PresentBlock)this.m_58900_().m_60734_()).getColor();
    }

    public static boolean isPacked(ItemStack stack) {
        CompoundTag com = stack.m_41783_();
        if (com != null) {
            CompoundTag nbt = com.m_128469_("BlockEntityTag");
            return nbt.m_128471_("Packed");
        }
        return false;
    }

    public boolean isPacked() {
        return (Boolean)this.m_58900_().m_61143_((Property)PresentBlock.PACKED);
    }

    public String getSender() {
        return this.sender;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRecipient() {
        if (this.recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return "";
        }
        return this.recipient;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setPublic() {
        this.setRecipient(PUBLIC_KEY);
    }

    public void updateState(boolean shouldPack, String newRecipient, String sender, String description) {
        if (shouldPack) {
            if (newRecipient.isEmpty()) {
                newRecipient = PUBLIC_KEY;
            }
            this.recipient = newRecipient;
            this.sender = sender;
            this.description = description;
        } else {
            this.recipient = "";
            this.sender = "";
            this.description = "";
        }
        if (!this.f_58857_.f_46443_ && this.isPacked() != shouldPack) {
            if (shouldPack) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModRegistry.PRESENT_PACK_SOUND.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.95f);
            } else {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12639_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 1.2f);
            }
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(shouldPack)), 3);
        }
    }

    public boolean m_7525_(Player player) {
        return this.recipient.isEmpty() || this.recipient.equalsIgnoreCase(PUBLIC_KEY) || this.recipient.equalsIgnoreCase(player.m_7755_().getString()) || this.sender.equalsIgnoreCase(player.m_7755_().getString());
    }

    public InteractionResult interact(ServerPlayer player, BlockPos pos) {
        if (this.isUnused()) {
            if (this.m_7525_((Player)player)) {
                NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)this, (BlockPos)pos);
                PiglinAi.m_34873_((Player)player, (boolean)true);
            } else {
                player.m_5661_((Component)new TranslatableComponent("message.supplementaries.present.info", new Object[]{this.recipient}), true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public Component m_6820_() {
        return new TranslatableComponent("gui.supplementaries.present");
    }

    @Override
    protected void updateBlockState(BlockState state, boolean b) {
    }

    @Override
    protected void playOpenSound(BlockState state) {
    }

    @Override
    protected void playCloseSound(BlockState state) {
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.recipient = "";
        this.sender = "";
        this.description = "";
        if (tag.m_128441_("Recipient")) {
            this.recipient = tag.m_128461_("Recipient");
        }
        if (tag.m_128441_("Sender")) {
            this.sender = tag.m_128461_("Sender");
        }
        if (tag.m_128441_("Description")) {
            this.description = tag.m_128461_("Description");
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.recipient.isEmpty()) {
            tag.m_128359_("Recipient", this.recipient);
        }
        if (!this.sender.isEmpty()) {
            tag.m_128359_("Sender", this.sender);
        }
        if (!this.description.isEmpty()) {
            tag.m_128359_("Description", this.description);
        }
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new PresentContainerMenu(id, player, (Container)this, this.f_58858_);
    }

    public static boolean isAcceptableItem(ItemStack stack) {
        return CommonUtil.isAllowedInShulker(stack) && !(stack.m_41720_() instanceof PresentItem);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return PresentBlockTile.isAcceptableItem(stack);
    }

    public boolean m_7155_(int p_19235_, ItemStack p_19236_, @Nullable Direction p_19237_) {
        return false;
    }

    public boolean m_7157_(int p_19239_, ItemStack p_19240_, Direction p_19241_) {
        return false;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ItemStack getPresentItem(ItemLike block2) {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        ItemStack itemstack = new ItemStack(block2);
        if (!compoundTag.m_128456_()) {
            itemstack.m_41700_("BlockEntityTag", (Tag)compoundTag);
        }
        if (this.m_8077_()) {
            itemstack.m_41714_(this.m_7770_());
        }
        return itemstack;
    }

    @Nullable
    public Component getSenderMessage() {
        return PresentBlockTile.getSenderMessage(this.sender);
    }

    @Nullable
    public static Component getSenderMessage(String sender) {
        if (sender.isEmpty()) {
            return null;
        }
        return new TranslatableComponent("message.supplementaries.present.from", new Object[]{sender});
    }

    @Nullable
    public Component getRecipientMessage() {
        return PresentBlockTile.getRecipientMessage(this.recipient);
    }

    @Nullable
    public static Component getRecipientMessage(String recipient) {
        if (recipient.isEmpty()) {
            return null;
        }
        if (recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return new TranslatableComponent("message.supplementaries.present.public");
        }
        return new TranslatableComponent("message.supplementaries.present.to", new Object[]{recipient});
    }
}

