/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.api.IRotatable;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.utils.VectorUtils;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockUtils {
    public static <T extends Comparable<T>, A extends Property<T>> BlockState replaceProperty(BlockState from, BlockState to, A property) {
        if (from.m_61138_(property)) {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        return to;
    }

    public static <T extends BlockEntity> void addOptionalOwnership(LivingEntity placer, T tileEntity) {
        if (ServerConfigs.cached.SERVER_PROTECTION && placer instanceof Player) {
            ((IOwnerProtected)tileEntity).setOwner(placer.m_142081_());
        }
    }

    public static void addOptionalOwnership(LivingEntity placer, Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (ServerConfigs.cached.SERVER_PROTECTION && placer instanceof Player && (blockEntity = world.m_7702_(pos)) instanceof IOwnerProtected) {
            IOwnerProtected tile = (IOwnerProtected)blockEntity;
            tile.setOwner(placer.m_142081_());
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static Optional<Direction> tryRotatingBlockAndConnected(Direction face, boolean ccw, BlockPos targetPos, Level level, Vec3 hit) {
        BlockState state = level.m_8055_(targetPos);
        Block block2 = state.m_60734_();
        if (block2 instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)block2;
            return rotatable.rotateOverAxis(state, (LevelAccessor)level, targetPos, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, face, hit);
        }
        Optional<Direction> special = BlockUtils.tryRotatingSpecial(face, ccw, targetPos, level, state, hit);
        if (special.isPresent()) {
            return special;
        }
        return BlockUtils.tryRotatingBlock(face, ccw, targetPos, level, state, hit);
    }

    public static Optional<Direction> tryRotatingBlock(Direction face, boolean ccw, BlockPos targetPos, Level level, Vec3 hit) {
        Optional<Direction> opt = BlockUtils.tryRotatingBlock(face, ccw, targetPos, level, level.m_8055_(targetPos), hit);
        if (opt.isEmpty()) {
            opt = BlockUtils.tryRotatingBlock(Direction.UP, ccw, targetPos, level, level.m_8055_(targetPos), hit);
        }
        return opt;
    }

    public static Optional<Direction> tryRotatingBlock(Direction dir, boolean ccw, BlockPos targetPos, Level world, BlockState state, Vec3 hit) {
        BlockState rotated;
        Block block2 = state.m_60734_();
        if (block2 instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)block2;
            return rotatable.rotateOverAxis(state, (LevelAccessor)world, targetPos, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, dir, hit);
        }
        Optional<BlockState> optional = BlockUtils.getRotatedState(dir, ccw, targetPos, world, state);
        if (optional.isPresent() && (rotated = optional.get()).m_60710_((LevelReader)world, targetPos) && (rotated = Block.m_49931_((BlockState)rotated, (LevelAccessor)world, (BlockPos)targetPos)) != state) {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                world.m_7731_(targetPos, rotated, 11);
            }
            return Optional.of(dir);
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getRotatedState(Direction dir, boolean ccw, BlockPos targetPos, Level world, BlockState state) {
        if (BlockUtils.isBlacklisted(state)) {
            return Optional.empty();
        }
        Rotation rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        Block block2 = state.m_60734_();
        if (state.m_61138_((Property)BlockProperties.FLIPPED)) {
            return Optional.of((BlockState)state.m_61122_((Property)BlockProperties.FLIPPED));
        }
        if (dir.m_122434_() == Direction.Axis.Y) {
            int bites;
            if (block2 == Blocks.f_50145_ && (bites = ((Integer)state.m_61143_((Property)CakeBlock.f_51180_)).intValue()) != 0) {
                return Optional.of(((BlockState)((Block)ModRegistry.DIRECTIONAL_CAKE.get()).m_49966_().m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(bites))).rotate((LevelAccessor)world, targetPos, rot));
            }
            BlockState rotated = state.rotate((LevelAccessor)world, targetPos, rot);
            if (rotated == state) {
                if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    rotated = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
                } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    rotated = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
                } else if (state.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
                    rotated = RotatedPillarBlock.m_154376_((BlockState)state, (Rotation)rot);
                } else if (state.m_61138_((Property)BlockStateProperties.f_61364_)) {
                    rotated = (BlockState)state.m_61122_((Property)BlockStateProperties.f_61364_);
                }
            }
            return Optional.of(rotated);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61376_) && state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return Optional.of(BlockUtils.rotateFaceBlockHorizontal(dir, ccw, state));
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return Optional.of(BlockUtils.rotateBlockStateOnAxis(state, dir, ccw));
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            Direction.Axis targetAxis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            Direction.Axis myAxis = dir.m_122434_();
            if (myAxis == Direction.Axis.X) {
                return Optional.of((BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y)));
            }
            if (myAxis == Direction.Axis.Z) {
                return Optional.of((BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y)));
            }
        }
        if (block2 instanceof StairBlock) {
            boolean positive;
            Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
            if (facing.m_122434_() == dir.m_122434_()) {
                return Optional.empty();
            }
            boolean flipped = dir.m_122421_() == Direction.AxisDirection.POSITIVE ^ ccw;
            Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
            boolean top = half == Half.TOP;
            boolean bl = positive = facing.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (top ^ positive ^ flipped) {
                half = top ? Half.BOTTOM : Half.TOP;
            } else {
                facing = facing.m_122424_();
            }
            return Optional.of((BlockState)((BlockState)state.m_61124_((Property)StairBlock.f_56842_, (Comparable)half)).m_61124_((Property)StairBlock.f_56841_, (Comparable)facing));
        }
        if (state.m_61138_((Property)SlabBlock.f_56353_)) {
            SlabType type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
            if (type == SlabType.DOUBLE) {
                return Optional.empty();
            }
            return Optional.of((BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)(type == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM)));
        }
        if (state.m_61138_((Property)TrapDoorBlock.f_57515_)) {
            return Optional.of((BlockState)state.m_61122_((Property)TrapDoorBlock.f_57515_));
        }
        return Optional.empty();
    }

    private static BlockState rotateBlockStateOnAxis(BlockState state, Direction axis, boolean ccw) {
        Vec3 rotated;
        Vec3 targetNormal = VectorUtils.ItoD(((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_());
        Vec3 myNormal = VectorUtils.ItoD(axis.m_122436_());
        if (!ccw) {
            targetNormal = targetNormal.m_82490_(-1.0);
        }
        if ((rotated = myNormal.m_82537_(targetNormal)) != Vec3.f_82478_) {
            Direction newDir = Direction.m_122366_((double)rotated.m_7096_(), (double)rotated.m_7098_(), (double)rotated.m_7094_());
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)newDir);
        }
        return state;
    }

    private static boolean isBlacklisted(BlockState state) {
        if (state.m_60734_() instanceof BedBlock) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61392_) && state.m_61143_((Property)BlockStateProperties.f_61392_) != ChestType.SINGLE) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61432_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61432_)).booleanValue()) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61449_)) {
            return true;
        }
        return state.m_204336_(ModTags.ROTATION_BLACKLIST);
    }

    private static Optional<Direction> tryRotatingSpecial(Direction face, boolean ccw, BlockPos pos, Level level, BlockState state, Vec3 hit) {
        Rotation rot;
        Block b = state.m_60734_();
        Rotation rotation = rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        if (state.m_61138_((Property)BlockStateProperties.f_61390_)) {
            int r = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
            if ((r += ccw ? -1 : 1) < 0) {
                r += 16;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(r %= 16)), 2);
            return Optional.of(Direction.UP);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61432_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61432_)).booleanValue() && state.m_61138_((Property)PistonHeadBlock.f_52588_)) {
            BlockPos newHeadPos;
            BlockState newBase = BlockUtils.rotateBlockStateOnAxis(state, face, ccw);
            BlockPos headPos = pos.m_142300_((Direction)state.m_61143_((Property)PistonHeadBlock.f_52588_));
            if (level.m_8055_(headPos).m_61138_((Property)PistonHeadBlock.f_60236_) && level.m_8055_(newHeadPos = pos.m_142300_((Direction)newBase.m_61143_((Property)PistonHeadBlock.f_52588_))).m_60767_().m_76336_()) {
                level.m_7731_(newHeadPos, BlockUtils.rotateBlockStateOnAxis(level.m_8055_(headPos), face, ccw), 2);
                level.m_7731_(pos, newBase, 2);
                level.m_7471_(headPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61449_) && state.m_61138_((Property)PistonHeadBlock.f_52588_)) {
            BlockPos newHeadPos;
            BlockState newBase = BlockUtils.rotateBlockStateOnAxis(state, face, ccw);
            BlockPos headPos = pos.m_142300_(((Direction)state.m_61143_((Property)PistonHeadBlock.f_52588_)).m_122424_());
            if (level.m_8055_(headPos).m_61138_((Property)PistonBaseBlock.f_60153_) && level.m_8055_(newHeadPos = pos.m_142300_(((Direction)newBase.m_61143_((Property)PistonHeadBlock.f_52588_)).m_122424_())).m_60767_().m_76336_()) {
                level.m_7731_(newHeadPos, BlockUtils.rotateBlockStateOnAxis(level.m_8055_(headPos), face, ccw), 2);
                level.m_7731_(pos, newBase, 2);
                level.m_7471_(headPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (b instanceof BedBlock) {
            BlockState newBed = state.rotate((LevelAccessor)level, pos, rot);
            BlockPos oldPos = pos.m_142300_(BlockUtils.getConnectedBedDirection(state));
            BlockPos targetPos = pos.m_142300_(BlockUtils.getConnectedBedDirection(newBed));
            if (level.m_8055_(targetPos).m_60767_().m_76336_()) {
                level.m_7731_(targetPos, level.m_8055_(oldPos).rotate((LevelAccessor)level, oldPos, rot), 2);
                level.m_7731_(pos, newBed, 2);
                level.m_7471_(oldPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (b instanceof ChestBlock) {
            if (state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
                BlockState newChest = state.rotate((LevelAccessor)level, pos, rot);
                BlockPos oldPos = pos.m_142300_(ChestBlock.m_51584_((BlockState)state));
                BlockPos targetPos = pos.m_142300_(ChestBlock.m_51584_((BlockState)newChest));
                if (level.m_8055_(targetPos).m_60767_().m_76336_()) {
                    BlockState connectedNewState = level.m_8055_(oldPos).rotate((LevelAccessor)level, oldPos, rot);
                    level.m_7731_(targetPos, connectedNewState, 2);
                    level.m_7731_(pos, newChest, 2);
                    BlockEntity tile = level.m_7702_(oldPos);
                    if (tile != null) {
                        CompoundTag tag = tile.m_187482_();
                        BlockEntity blockEntity = level.m_7702_(targetPos);
                        if (blockEntity instanceof ChestBlockEntity) {
                            ChestBlockEntity newChestTile = (ChestBlockEntity)blockEntity;
                            newChestTile.m_142466_(tag);
                        }
                        tile.m_7651_();
                    }
                    level.m_46597_(oldPos, Blocks.f_50016_.m_49966_());
                    return Optional.of(face);
                }
            }
            return Optional.empty();
        }
        if (DoorBlock.m_52817_((BlockState)state)) {
            // empty if block
        }
        return Optional.empty();
    }

    private static Direction getConnectedBedDirection(BlockState bedState) {
        BedPart part = (BedPart)bedState.m_61143_((Property)BedBlock.f_49440_);
        Direction dir = (Direction)bedState.m_61143_((Property)BedBlock.f_54117_);
        return part == BedPart.FOOT ? dir : dir.m_122424_();
    }

    private static BlockState rotateFaceBlockHorizontal(Direction dir, boolean ccw, BlockState original) {
        Direction facingDir = (Direction)original.m_61143_((Property)BlockStateProperties.f_61374_);
        if (facingDir.m_122434_() == dir.m_122434_()) {
            return original;
        }
        AttachFace face = (AttachFace)original.m_61143_((Property)BlockStateProperties.f_61376_);
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> (BlockState)((BlockState)original.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.WALL)).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)(ccw ? dir.m_122427_() : dir.m_122428_()));
            case AttachFace.CEILING -> (BlockState)((BlockState)original.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.WALL)).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)(!ccw ? dir.m_122427_() : dir.m_122428_()));
            case AttachFace.WALL -> (BlockState)original.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)(facingDir.m_122421_() == Direction.AxisDirection.POSITIVE ^ (ccw ^= dir.m_122421_() != Direction.AxisDirection.POSITIVE) ? AttachFace.CEILING : AttachFace.FLOOR));
        };
    }

    public static class PlayerLessContext
    extends BlockPlaceContext {
        public PlayerLessContext(Level worldIn, @Nullable Player playerIn, InteractionHand handIn, ItemStack stackIn, BlockHitResult rayTraceResultIn) {
            super(worldIn, playerIn, handIn, stackIn, rayTraceResultIn);
        }
    }
}

