/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.items.IPlaceableItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;

public class BlockPlacerItem
extends BlockItem {
    public static final Map<Block, Pair<Supplier<? extends Item>, ForgeConfigSpec.BooleanValue>> PLACEABLE_ITEMS = new HashMap<Block, Pair<Supplier<? extends Item>, ForgeConfigSpec.BooleanValue>>();
    private FoodProperties mimicFood;
    private Block mimicBlock;
    private SoundType overrideSound;

    public static BlockPlacerItem getInstance() {
        return (BlockPlacerItem)((Object)ModRegistry.BLOCK_PLACER.get());
    }

    public static void registerPlaceableItem(Block block2, Supplier<? extends Item> item2, ForgeConfigSpec.BooleanValue config) {
        PLACEABLE_ITEMS.put(block2, (Pair<Supplier<? extends Item>, ForgeConfigSpec.BooleanValue>)Pair.of(item2, (Object)config));
    }

    public BlockPlacerItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public void m_6192_(Map<Block, Item> pBlockToItemMap, Item pItem) {
        super.m_6192_(pBlockToItemMap, pItem);
        for (Map.Entry<Block, Pair<Supplier<? extends Item>, ForgeConfigSpec.BooleanValue>> v : PLACEABLE_ITEMS.entrySet()) {
            Block b = v.getKey();
            Item i = (Item)((Supplier)v.getValue().getFirst()).get();
            if (i == null || i == Items.f_41852_ || b == null || b == Blocks.f_50016_) continue;
            ((IPlaceableItem)i).makePlaceable(b);
            pBlockToItemMap.put(b, i);
        }
    }

    private boolean isEnabled(Block b) {
        Pair<Supplier<? extends Item>, ForgeConfigSpec.BooleanValue> p = PLACEABLE_ITEMS.get(b);
        return p == null || (Boolean)((ForgeConfigSpec.BooleanValue)p.getSecond()).get() != false;
    }

    @Nullable
    public BlockState mimicGetPlacementState(BlockPlaceContext pContext, Block toPlace) {
        if (!this.isEnabled(toPlace)) {
            return null;
        }
        this.mimicBlock = toPlace;
        BlockState r = this.m_5965_(pContext);
        this.mimicBlock = null;
        return r;
    }

    public InteractionResult mimicUseOn(UseOnContext pContext, Block toPlace, FoodProperties foodProperties) {
        if (!this.isEnabled(toPlace)) {
            return InteractionResult.PASS;
        }
        this.mimicFood = foodProperties;
        this.mimicBlock = toPlace;
        InteractionResult r = super.m_6225_(pContext);
        this.mimicFood = null;
        this.mimicBlock = null;
        return r;
    }

    public InteractionResult mimicPlace(BlockPlaceContext pContext, Block toPlace, @Nullable SoundType overrideSound) {
        if (!this.isEnabled(toPlace)) {
            return InteractionResult.PASS;
        }
        this.overrideSound = overrideSound;
        this.mimicBlock = toPlace;
        InteractionResult r = super.m_40576_(pContext);
        this.overrideSound = null;
        this.mimicBlock = null;
        return r;
    }

    public Block m_40614_() {
        if (this.mimicBlock != null) {
            return this.mimicBlock;
        }
        return super.m_40614_();
    }

    @Nullable
    public FoodProperties m_41473_() {
        return this.mimicFood;
    }

    public boolean m_41472_() {
        return this.mimicFood != null;
    }

    protected SoundEvent m_40587_(BlockState pState) {
        if (this.overrideSound != null) {
            return this.overrideSound.m_56777_();
        }
        return super.m_40587_(pState);
    }

    protected SoundEvent getPlaceSound(BlockState state, Level world, BlockPos pos, Player entity2) {
        if (this.overrideSound != null) {
            return this.overrideSound.m_56777_();
        }
        return super.getPlaceSound(state, world, pos, entity2);
    }
}

