/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.api.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.selene.api.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.selene.api.IThirdPersonSpecialItemRenderer;
import net.mehvahdjukaar.selene.util.TwoHandedAnimation;
import net.mehvahdjukaar.supplementaries.client.renderers.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.renderers.items.FluteItemRenderer;
import net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ClientRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;

public class FluteItem
extends InstrumentItem
implements IThirdPersonAnimationProvider,
IThirdPersonSpecialItemRenderer,
IFirstPersonAnimationProvider {
    public FluteItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.m_150930_(Items.f_41911_);
    }

    public boolean m_5812_(ItemStack pStack) {
        CompoundTag tag = pStack.m_41783_();
        if (tag == null) {
            return false;
        }
        return tag.m_128441_("Pet") || super.m_5812_(pStack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        TamableAnimal animal;
        CompoundTag c = stack.m_41737_("Pet");
        if (c == null && target instanceof TamableAnimal && (animal = (TamableAnimal)target).m_21824_() && animal.m_142504_().equals(playerIn.m_142081_()) || target.m_6095_().m_204039_(ModTags.FLUTE_PET)) {
            AbstractHorse horse;
            if (target instanceof AbstractHorse && !(horse = (AbstractHorse)target).m_30614_()) {
                return InteractionResult.PASS;
            }
            CompoundTag com = new CompoundTag();
            com.m_128359_("Name", target.m_7755_().getString());
            com.m_128362_("UUID", target.m_142081_());
            com.m_128405_("ID", target.m_142049_());
            stack.m_41700_("Pet", (Tag)com);
            playerIn.m_21008_(hand, stack);
            playerIn.m_36335_().m_41524_((Item)this, 20);
            return InteractionResult.m_19078_((boolean)playerIn.f_19853_.f_46443_);
        }
        return super.m_6880_(stack, playerIn, target, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity2) {
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            return this.m_6880_(stack, player, livingEntity, player.m_7655_()).m_19077_();
        }
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack;
        block1: {
            block3: {
                int r;
                double z;
                double y;
                double x;
                block2: {
                    super.m_7203_(worldIn, playerIn, handIn);
                    stack = playerIn.m_21120_(handIn);
                    if (worldIn.f_46443_) break block1;
                    x = playerIn.m_20185_();
                    y = playerIn.m_20186_();
                    z = playerIn.m_20189_();
                    r = ServerConfigs.cached.FLUTE_RADIUS;
                    CompoundTag com = stack.m_41737_("Pet");
                    if (com == null) break block2;
                    Entity entity2 = worldIn.m_6815_(com.m_128451_("ID"));
                    int maxDist = ServerConfigs.cached.FLUTE_DISTANCE * ServerConfigs.cached.FLUTE_DISTANCE;
                    if (!(entity2 instanceof LivingEntity)) break block3;
                    LivingEntity pet = (LivingEntity)entity2;
                    if (pet.f_19853_ != playerIn.f_19853_ || !(pet.m_20280_((Entity)playerIn) < (double)maxDist) || !pet.m_20984_(x, y, z, false)) break block3;
                    pet.m_5796_();
                    break block3;
                }
                AABB bb = new AABB(x - (double)r, y - (double)r, z - (double)r, x + (double)r, y + (double)r, z + (double)r);
                List entities = worldIn.m_6249_((Entity)playerIn, bb, e -> e instanceof TamableAnimal);
                for (Entity e2 : entities) {
                    TamableAnimal pet = (TamableAnimal)e2;
                    if (!pet.m_21824_() || pet.m_21827_() || !pet.m_142504_().equals(playerIn.m_142081_())) continue;
                    pet.m_20984_(x, y, z, false);
                }
            }
            playerIn.m_36335_().m_41524_((Item)this, 20);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity entity2, int pTimeCharged) {
        super.m_5551_(pStack, pLevel, entity2, pTimeCharged);
        pStack.m_41622_(1, entity2, en -> en.m_21166_(EquipmentSlot.MAINHAND));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag tag = stack.m_41737_("Pet");
        if (tag != null) {
            tooltip.add((Component)new TextComponent(tag.m_128461_("Name")).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public void spawnNoteParticle(Level level, LivingEntity entity2, int note) {
        if (!ClientConfigs.cached.FLUTE_PARTICLES) {
            return;
        }
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float toRad = (float)Math.PI / 180;
        float xRot = -entity2.m_146909_() * toRad;
        float yRot = -Mth.m_14177_((float)entity2.f_20885_) * toRad;
        bx = bx.m_82496_(xRot).m_82524_(yRot);
        by = by.m_82496_(xRot).m_82524_(yRot);
        bz = bz.m_82496_(xRot).m_82524_(yRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 0.28 + (double)level.f_46441_.nextFloat() * 0.5);
        int mirror = entity2.m_5737_() == HumanoidArm.RIGHT ^ entity2.m_7655_() == InteractionHand.MAIN_HAND ? -1 : 1;
        armVec = armVec.m_82524_((float)(-1.5707963267948966 * (double)mirror)).m_82520_(0.0, 0.15, 0.1);
        Vec3 newV = bx.m_82490_(armVec.f_82479_).m_82549_(by.m_82490_(armVec.f_82480_)).m_82549_(bz.m_82490_(armVec.f_82481_));
        double x = entity2.m_20185_() + newV.f_82479_;
        double y = entity2.m_20188_() + newV.f_82480_;
        double z = entity2.m_20189_() + newV.f_82481_;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x, y, z, (double)level.f_46441_.nextInt(24) / 24.0, 0.0, 0.0);
    }

    public void animateItemFirstPerson(LivingEntity entity2, ItemStack stack, InteractionHand hand, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity2.m_6117_() && entity2.m_21212_() > 0 && entity2.m_7655_() == hand) {
            int mirror = entity2.m_5737_() == HumanoidArm.RIGHT ^ hand == InteractionHand.MAIN_HAND ? -1 : 1;
            matrixStack.m_85837_(-0.4 * (double)mirror, 0.2, 0.0);
            float timeLeft = (float)stack.m_41779_() - ((float)entity2.m_21212_() - partialTicks + 1.0f);
            float sin = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
            matrixStack.m_85837_(0.0, (double)(sin * 0.0038f), 0.0);
            matrixStack.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
            matrixStack.m_85841_(1.0f * (float)mirror, -1.0f * (float)mirror, -1.0f);
        }
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity2, HumanoidArm mainHand, TwoHandedAnimation twoHanded) {
        if (entity2.m_21212_() > 0 && entity2.m_21211_().m_41720_() == this) {
            this.animateHands(model, entity2, false);
            twoHanded.setTwoHanded(true);
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity2, HumanoidArm mainHand, TwoHandedAnimation twoHanded) {
        if (entity2.m_21212_() > 0 && entity2.m_21211_().m_41720_() == this) {
            this.animateHands(model, entity2, true);
            twoHanded.setTwoHanded(true);
            return true;
        }
        return false;
    }

    private <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity2, boolean leftHand) {
        ModelPart mainHand = leftHand ? model.f_102812_ : model.f_102811_;
        ModelPart offHand = leftHand ? model.f_102811_ : model.f_102812_;
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float headXRot = RotHlpr.wrapRad(model.f_102808_.f_104203_);
        float headYRot = RotHlpr.wrapRad(model.f_102808_.f_104204_);
        float downFacingRot = Mth.m_14036_((float)headXRot, (float)0.0f, (float)0.8f);
        float xRot = FluteItem.getMaxHeadXRot(headXRot) - (entity2.m_6047_() ? 1.0f : 0.0f) - 0.3f + downFacingRot * 0.5f;
        bx = bx.m_82496_(xRot);
        by = by.m_82496_(xRot);
        bz = bz.m_82496_(xRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 1.0);
        float mirror = leftHand ? -1.0f : 1.0f;
        armVec = armVec.m_82524_(-0.99f * mirror);
        Vec3 newV = bx.m_82490_(armVec.f_82479_).m_82549_(by.m_82490_(armVec.f_82480_)).m_82549_(bz.m_82490_(armVec.f_82481_));
        float yaw = (float)Math.atan2(-newV.f_82479_, newV.f_82481_);
        float len = (float)newV.m_82553_();
        float pitch = (float)Math.asin(newV.f_82480_ / (double)len);
        mainHand.f_104204_ = yaw + headYRot * 1.4f - 0.1f * mirror - 0.5f * downFacingRot * mirror;
        mainHand.f_104203_ = (float)((double)pitch - 1.5707963267948966);
        offHand.f_104204_ = (float)Mth.m_14008_((double)((double)(RotHlpr.wrapRad(mainHand.f_104204_) - 1.0f * mirror) * 0.2), (double)-0.15, (double)0.15) + 1.1f * mirror;
        offHand.f_104203_ = RotHlpr.wrapRad(mainHand.f_104203_ - 0.06f);
        float offset = leftHand ? -Mth.m_14036_((float)headYRot, (float)-1.0f, (float)0.0f) : Mth.m_14036_((float)headYRot, (float)0.0f, (float)1.0f);
        mainHand.f_104202_ = -offset * 0.95f;
        AnimationUtils.m_170341_((ModelPart)model.f_102812_, (float)entity2.f_19797_, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)model.f_102811_, (float)entity2.f_19797_, (float)-1.0f);
    }

    public static float getMaxHeadXRot(float xRot) {
        return Mth.m_14036_((float)xRot, (float)-1.2566371f, (float)1.5707964f);
    }

    public <T extends Player, M extends EntityModel<T> & HeadedModel> void renderThirdPersonItem(M parentModel, LivingEntity entity2, ItemStack stack, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!stack.m_41619_()) {
            ItemTransforms.TransformType transform;
            boolean leftHand;
            poseStack.m_85836_();
            boolean bl = leftHand = humanoidArm == HumanoidArm.LEFT;
            if (entity2.m_21211_() == stack) {
                ModelPart head = ((HeadedModel)parentModel).m_5585_();
                float oldRot = head.f_104203_;
                head.f_104203_ = FluteItem.getMaxHeadXRot(RotHlpr.wrapRad(oldRot));
                head.m_104299_(poseStack);
                head.f_104203_ = oldRot;
                CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
                poseStack.m_85837_(0.0, -0.265625, -0.53125);
                if (leftHand) {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                }
                transform = ItemTransforms.TransformType.HEAD;
            } else {
                ((ArmedModel)parentModel).m_6002_(humanoidArm, poseStack);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                poseStack.m_85837_((double)((float)(leftHand ? -1 : 1) / 16.0f), 0.125, -0.625);
                transform = leftHand ? ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND : ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            Minecraft.m_91087_().m_91292_().m_109322_(entity2, stack, transform, leftHand, poseStack, bufferSource, light);
            poseStack.m_85849_();
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        ClientRegistry.registerISTER(consumer, FluteItemRenderer::new);
    }
}

