/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.util.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.util.TextHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSetTextHolderPacket {
    private final BlockPos pos;
    public final Component[] signText;
    public final int size;

    public ServerBoundSetTextHolderPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.size = buf.readInt();
        this.signText = new Component[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.signText[i] = buf.m_130238_();
        }
    }

    public ServerBoundSetTextHolderPacket(BlockPos pos, TextHolder textHolder) {
        this.pos = pos;
        this.size = textHolder.size();
        this.signText = textHolder.getSignText();
    }

    public static void buffer(ServerBoundSetTextHolderPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeInt(message.size);
        for (int i = 0; i < message.size; ++i) {
            buf.m_130083_(message.signText[i]);
        }
    }

    public static void handler(ServerBoundSetTextHolderPacket message, Supplier<NetworkEvent.Context> ctx) {
        Level world = Objects.requireNonNull(ctx.get().getSender()).f_19853_;
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof ITextHolderProvider) {
                ITextHolderProvider te = (ITextHolderProvider)tile;
                if (te.getTextHolder().size() == message.size) {
                    for (int i = 0; i < message.size; ++i) {
                        te.getTextHolder().setLine(i, message.signText[i]);
                    }
                }
                BlockState state = world.m_8055_(pos);
                world.m_7260_(pos, state, state, 3);
                tile.m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

