/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.RPAwareDynamicDataProvider;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.common.items.crafting.OptionalRecipeCondition;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesHandler
extends RPAwareDynamicDataProvider {
    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(Supplementaries.res("virtual_resourcepack")));
        ((DynamicDataPack)this.dynamicPack).generateDebugResources = (Boolean)RegistryConfigs.reg.DEBUG_RESOURCES.get();
    }

    public Logger getLogger() {
        return Supplementaries.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return false;
    }

    public void regenerateDynamicAssets(ResourceManager resourceManager) {
    }

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
        ArrayList<ResourceLocation> signs = new ArrayList<ResourceLocation>();
        for (HangingSignBlock hangingSignBlock : ModRegistry.HANGING_SIGNS.values()) {
            ((DynamicDataPack)this.dynamicPack).addSimpleBlockLootTable((Block)hangingSignBlock);
            signs.add(hangingSignBlock.getRegistryName());
            this.makeHangingSignRecipe(hangingSignBlock.woodType, arg_0 -> ((DynamicDataPack)((DynamicDataPack)this.dynamicPack)).addRecipe(arg_0));
        }
        ((DynamicDataPack)this.dynamicPack).addTag(Supplementaries.res("hanging_signs"), signs, Registry.f_122901_);
        ((DynamicDataPack)this.dynamicPack).addTag(Supplementaries.res("hanging_signs"), signs, Registry.f_122904_);
        ArrayList<ResourceLocation> posts = new ArrayList<ResourceLocation>();
        for (SignPostItem signPostItem : ModRegistry.SIGN_POST_ITEMS.values()) {
            posts.add(signPostItem.getRegistryName());
            this.makeSignPostRecipe(signPostItem.woodType, arg_0 -> ((DynamicDataPack)((DynamicDataPack)this.dynamicPack)).addRecipe(arg_0));
        }
        ((DynamicDataPack)this.dynamicPack).addTag(Supplementaries.res("sign_posts"), posts, Registry.f_122904_);
        ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
        for (Map.Entry entry : ForgeRegistries.BIOMES.getEntries()) {
            Holder holder = BuiltinRegistries.f_123865_.m_206081_((ResourceKey)entry.getKey());
            Biome.BiomeCategory biomeCategory = Biome.m_204183_((Holder)holder);
            if (biomeCategory != Biome.BiomeCategory.OCEAN && biomeCategory != Biome.BiomeCategory.THEEND && biomeCategory != Biome.BiomeCategory.RIVER && biomeCategory != Biome.BiomeCategory.UNDERGROUND && biomeCategory != Biome.BiomeCategory.JUNGLE && biomeCategory != Biome.BiomeCategory.NETHER && biomeCategory != Biome.BiomeCategory.NONE && !((Biome)entry.getValue()).getRegistryName().m_135815_().equals("minecraft:mushroom_fields")) {
                biomes.add(((Biome)entry.getValue()).getRegistryName());
            }
            ((DynamicDataPack)this.dynamicPack).addTag(Supplementaries.res("has_way_signs"), biomes, Registry.f_122885_);
        }
    }

    private void makeConditionalRec(FinishedRecipe r, Consumer<FinishedRecipe> consumer, String name) {
        ConditionalRecipe.builder().addCondition((ICondition)new OptionalRecipeCondition(name)).addRecipe(r).build(consumer, "supplementaries", name);
    }

    private void makeConditionalWoodRec(FinishedRecipe r, WoodType wood, Consumer<FinishedRecipe> consumer, String name) {
        ConditionalRecipe.builder().addCondition((ICondition)new OptionalRecipeCondition(name)).addCondition((ICondition)new ModLoadedCondition(wood.getNamespace())).addRecipe(r).generateAdvancement().build(consumer, "supplementaries", name + "_" + wood.getAppendableId());
    }

    private ResourceLocation getPlankRegName(WoodType wood) {
        return new ResourceLocation(wood.getNamespace(), wood.getWoodName() + "_planks");
    }

    private ResourceLocation getSignRegName(WoodType wood) {
        return new ResourceLocation(wood.getNamespace(), wood.getWoodName() + "_sign");
    }

    private void makeSignPostRecipe(WoodType wood, Consumer<FinishedRecipe> consumer) {
        try {
            Item plank = wood.plankBlock.m_5456_();
            Preconditions.checkArgument((plank != Items.f_41852_ ? 1 : 0) != 0);
            Item sign = (Item)ForgeRegistries.ITEMS.getValue(this.getSignRegName(wood));
            if (sign != null && sign != Items.f_41852_) {
                ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(wood)), (int)2).m_126209_((ItemLike)sign).m_142409_("sign_post").m_142284_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{plank})).m_176498_(s -> this.makeConditionalWoodRec((FinishedRecipe)s, wood, consumer, "sign_post"));
            } else {
                ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModRegistry.SIGN_POST_ITEMS.get(wood)), (int)3).m_126130_("   ").m_126130_("222").m_126130_(" 1 ").m_126127_(Character.valueOf('1'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('2'), (ItemLike)plank).m_142409_("sign_post").m_142284_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{plank})).m_176498_(s -> this.makeConditionalWoodRec((FinishedRecipe)s, wood, consumer, "sign_post"));
            }
        }
        catch (Exception ignored) {
            Supplementaries.LOGGER.error("Failed to generate sign post recipe for wood type {}", (Object)wood);
        }
    }

    private void makeHangingSignRecipe(WoodType wood, Consumer<FinishedRecipe> consumer) {
        try {
            Item plank = wood.plankBlock.m_5456_();
            Preconditions.checkArgument((plank != Items.f_41852_ ? 1 : 0) != 0);
            ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ModRegistry.HANGING_SIGNS.get(wood)), (int)2).m_126130_("010").m_126130_("222").m_126130_("222").m_126127_(Character.valueOf('0'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('1'), (ItemLike)Items.f_42398_).m_126127_(Character.valueOf('2'), (ItemLike)plank).m_142409_("hanging_sign").m_142284_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{plank})).m_176498_(s -> this.makeConditionalWoodRec((FinishedRecipe)s, wood, consumer, "hanging_sign"));
        }
        catch (Exception ignored) {
            Supplementaries.LOGGER.error("Failed to generate hanging sign recipe for wood type {}", (Object)wood);
        }
    }
}

