/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.quark;

import net.mehvahdjukaar.supplementaries.common.items.ItemsUtil;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.integration.quark.InventoryTooltipComponent;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import vazkii.quark.addons.oddities.item.BackpackItem;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.building.block.WoodPostBlock;
import vazkii.quark.content.building.module.VerticalSlabsModule;
import vazkii.quark.content.tools.item.AncientTomeItem;
import vazkii.quark.content.tweaks.module.DoubleDoorOpeningModule;

public class QuarkPlugin {
    public static boolean hasQButtonOnRight() {
        return GeneralConfig.qButtonOnRight && GeneralConfig.enableQButton;
    }

    @Nullable
    public static BlockState updateWoodPostShape(BlockState post, Direction facing, BlockState facingState) {
        if (post.m_60734_() instanceof WoodPostBlock) {
            Direction.Axis axis = (Direction.Axis)post.m_61143_((Property)WoodPostBlock.AXIS);
            if (facing.m_122434_() != axis) {
                boolean chain = facingState.m_60734_() instanceof ChainBlock && facingState.m_61143_((Property)BlockStateProperties.f_61365_) == facing.m_122434_();
                return (BlockState)post.m_61124_((Property)WoodPostBlock.CHAINED[facing.ordinal()], (Comparable)Boolean.valueOf(chain));
            }
        }
        return null;
    }

    public static boolean isTome(Item item2) {
        return item2 instanceof AncientTomeItem;
    }

    public static void registerTooltipComponent() {
        MinecraftForgeClient.registerTooltipComponentFactory(ItemsUtil.InventoryTooltip.class, InventoryTooltipComponent::new);
    }

    public static boolean isDoubleDoorEnabled() {
        return ModuleLoader.INSTANCE.isModuleEnabled(DoubleDoorOpeningModule.class);
    }

    public static int getSacksInBackpack(ItemStack stack) {
        LazyOptional handlerOpt;
        int j = 0;
        if (stack.m_41720_() instanceof BackpackItem && (handlerOpt = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).isPresent()) {
            IItemHandler handler = (IItemHandler)handlerOpt.orElse(null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slotItem = handler.getStackInSlot(i);
                if (!(slotItem.m_41720_() instanceof SackItem)) continue;
                ++j;
            }
        }
        return j;
    }

    public static boolean isVerticalSlabEnabled() {
        return ModuleLoader.INSTANCE.isModuleEnabled(VerticalSlabsModule.class);
    }
}

