/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstancingController;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityTypeExtension;
import com.jozufozu.flywheel.backend.instancing.blockentity.SimpleBlockEntityInstancingController;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstance;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstancingController;
import com.jozufozu.flywheel.backend.instancing.entity.EntityTypeExtension;
import com.jozufozu.flywheel.backend.instancing.entity.SimpleEntityInstancingController;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class InstancedRenderRegistry {
    public static <T extends BlockEntity> boolean canInstance(BlockEntityType<? extends T> type) {
        return InstancedRenderRegistry.getController(type) != null;
    }

    public static <T extends Entity> boolean canInstance(EntityType<? extends T> type) {
        return InstancedRenderRegistry.getController(type) != null;
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityInstance<? super T> createInstance(MaterialManager materialManager, T blockEntity) {
        BlockEntityInstancingController<T> controller = InstancedRenderRegistry.getController(InstancedRenderRegistry.getType(blockEntity));
        if (controller == null) {
            return null;
        }
        return controller.createInstance(materialManager, blockEntity);
    }

    @Nullable
    public static <T extends Entity> EntityInstance<? super T> createInstance(MaterialManager materialManager, T entity) {
        EntityInstancingController<T> controller = InstancedRenderRegistry.getController(InstancedRenderRegistry.getType(entity));
        if (controller == null) {
            return null;
        }
        return controller.createInstance(materialManager, entity);
    }

    public static <T extends BlockEntity> boolean shouldSkipRender(T blockEntity) {
        BlockEntityInstancingController<T> controller = InstancedRenderRegistry.getController(InstancedRenderRegistry.getType(blockEntity));
        if (controller == null) {
            return false;
        }
        return controller.shouldSkipRender(blockEntity);
    }

    public static <T extends Entity> boolean shouldSkipRender(T entity) {
        EntityInstancingController<T> controller = InstancedRenderRegistry.getController(InstancedRenderRegistry.getType(entity));
        if (controller == null) {
            return false;
        }
        return controller.shouldSkipRender(entity);
    }

    public static <T extends BlockEntity> BlockEntityConfig<T> configure(BlockEntityType<T> type) {
        return new BlockEntityConfig<T>(type);
    }

    public static <T extends Entity> EntityConfig<T> configure(EntityType<T> type) {
        return new EntityConfig<T>(type);
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityInstancingController<? super T> getController(BlockEntityType<T> type) {
        return ((BlockEntityTypeExtension)type).flywheel$getInstancingController();
    }

    @Nullable
    public static <T extends Entity> EntityInstancingController<? super T> getController(EntityType<T> type) {
        return ((EntityTypeExtension)type).flywheel$getInstancingController();
    }

    public static <T extends BlockEntity> void setController(BlockEntityType<T> type, BlockEntityInstancingController<? super T> instancingController) {
        ((BlockEntityTypeExtension)type).flywheel$setInstancingController(instancingController);
    }

    public static <T extends Entity> void setController(EntityType<T> type, EntityInstancingController<? super T> instancingController) {
        ((EntityTypeExtension)type).flywheel$setInstancingController(instancingController);
    }

    public static <T extends BlockEntity> BlockEntityType<? super T> getType(T blockEntity) {
        return blockEntity.m_58903_();
    }

    public static <T extends Entity> EntityType<? super T> getType(T entity) {
        return entity.m_6095_();
    }

    public static class BlockEntityConfig<T extends BlockEntity> {
        protected BlockEntityType<T> type;
        protected BiFunction<MaterialManager, T, BlockEntityInstance<? super T>> instanceFactory;
        protected Predicate<T> skipRender;

        public BlockEntityConfig(BlockEntityType<T> type) {
            this.type = type;
        }

        public BlockEntityConfig<T> factory(BiFunction<MaterialManager, T, BlockEntityInstance<? super T>> instanceFactory) {
            this.instanceFactory = instanceFactory;
            return this;
        }

        public BlockEntityConfig<T> skipRender(Predicate<T> skipRender) {
            this.skipRender = skipRender;
            return this;
        }

        public BlockEntityConfig<T> alwaysSkipRender() {
            this.skipRender = be -> true;
            return this;
        }

        public SimpleBlockEntityInstancingController<T> apply() {
            Objects.requireNonNull(this.instanceFactory, "Instance factory cannot be null!");
            if (this.skipRender == null) {
                this.skipRender = be -> false;
            }
            SimpleBlockEntityInstancingController<? super T> controller = new SimpleBlockEntityInstancingController<T>(this.instanceFactory, this.skipRender);
            InstancedRenderRegistry.setController(this.type, controller);
            return controller;
        }
    }

    public static class EntityConfig<T extends Entity> {
        protected EntityType<T> type;
        protected BiFunction<MaterialManager, T, EntityInstance<? super T>> instanceFactory;
        protected Predicate<T> skipRender;

        public EntityConfig(EntityType<T> type) {
            this.type = type;
        }

        public EntityConfig<T> factory(BiFunction<MaterialManager, T, EntityInstance<? super T>> instanceFactory) {
            this.instanceFactory = instanceFactory;
            return this;
        }

        public EntityConfig<T> skipRender(Predicate<T> skipRender) {
            this.skipRender = skipRender;
            return this;
        }

        public EntityConfig<T> alwaysSkipRender() {
            this.skipRender = entity -> true;
            return this;
        }

        public SimpleEntityInstancingController<T> apply() {
            Objects.requireNonNull(this.instanceFactory, "Instance factory cannot be null!");
            if (this.skipRender == null) {
                this.skipRender = entity -> false;
            }
            SimpleEntityInstancingController<? super T> controller = new SimpleEntityInstancingController<T>(this.instanceFactory, this.skipRender);
            InstancedRenderRegistry.setController(this.type, controller);
            return controller;
        }
    }
}

