/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.api.vertex.ShadedVertexList;
import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.core.model.Model;
import com.jozufozu.flywheel.util.DiffuseLightCalculator;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.function.IntPredicate;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;

public class ModelTransformer {
    private final Model model;
    private final VertexList reader;
    private final IntPredicate shadedPredicate;
    public final Context context = new Context();

    public ModelTransformer(Model model) {
        this.model = model;
        VertexList vertexList = this.reader = model.getReader();
        if (vertexList instanceof ShadedVertexList) {
            ShadedVertexList shaded = (ShadedVertexList)vertexList;
            this.shadedPredicate = shaded::isShaded;
        } else {
            this.shadedPredicate = index -> true;
        }
    }

    public void renderInto(Params params, PoseStack input, VertexConsumer builder) {
        Matrix3f normalMat;
        if (this.isEmpty()) {
            return;
        }
        Vector4f pos = new Vector4f();
        Vector3f normal = new Vector3f();
        Matrix4f modelMat = input.m_85850_().m_85861_().m_27658_();
        modelMat.m_27644_(params.model);
        if (this.context.fullNormalTransform) {
            normalMat = input.m_85850_().m_85864_().m_8183_();
            normalMat.m_8178_(params.normal);
        } else {
            normalMat = params.normal.m_8183_();
        }
        DiffuseLightCalculator diffuseCalculator = DiffuseLightCalculator.forCurrentLevel();
        int vertexCount = this.reader.getVertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            byte a;
            byte b;
            byte g;
            byte r;
            float x = this.reader.getX(i);
            float y = this.reader.getY(i);
            float z = this.reader.getZ(i);
            pos.m_123602_(x, y, z, 1.0f);
            pos.m_123607_(modelMat);
            builder.m_5483_((double)pos.m_123601_(), (double)pos.m_123615_(), (double)pos.m_123616_());
            float normalX = this.reader.getNX(i);
            float normalY = this.reader.getNY(i);
            float normalZ = this.reader.getNZ(i);
            normal.m_122245_(normalX, normalY, normalZ);
            normal.m_122249_(normalMat);
            normal.m_122278_();
            float nx = normal.m_122239_();
            float ny = normal.m_122260_();
            float nz = normal.m_122269_();
            if (params.useParamColor) {
                r = (byte)params.r;
                g = (byte)params.g;
                b = (byte)params.b;
                a = (byte)params.a;
            } else {
                r = this.reader.getR(i);
                g = this.reader.getG(i);
                b = this.reader.getB(i);
                a = this.reader.getA(i);
            }
            if (this.context.outputColorDiffuse) {
                float instanceDiffuse = diffuseCalculator.getDiffuse(nx, ny, nz, this.shadedPredicate.test(i));
                int colorR = ModelTransformer.transformColor(r, instanceDiffuse);
                int colorG = ModelTransformer.transformColor(g, instanceDiffuse);
                int colorB = ModelTransformer.transformColor(b, instanceDiffuse);
                builder.m_6122_(colorR, colorG, colorB, (int)a);
            } else {
                builder.m_6122_((int)r, (int)g, (int)b, (int)a);
            }
            float u = this.reader.getU(i);
            float v = this.reader.getV(i);
            if (params.spriteShiftFunc != null) {
                params.spriteShiftFunc.shift(builder, u, v);
            } else {
                builder.m_7421_(u, v);
            }
            builder.m_86008_(params.overlay);
            builder.m_85969_(params.useParamLight ? params.packedLightCoords : this.reader.getLight(i));
            builder.m_5601_(nx, ny, nz);
            builder.m_5752_();
        }
    }

    public boolean isEmpty() {
        return this.reader.isEmpty();
    }

    public String toString() {
        return "ModelTransformer[" + this.model + "]";
    }

    public static int transformColor(byte component, float scale) {
        return Mth.m_14045_((int)((int)((float)Byte.toUnsignedInt(component) * scale)), (int)0, (int)255);
    }

    public static int transformColor(int component, float scale) {
        return Mth.m_14045_((int)((int)((float)component * scale)), (int)0, (int)255);
    }

    public static class Context {
        public boolean fullNormalTransform = false;
        public boolean outputColorDiffuse = true;
    }

    public static class Params
    implements Transform<Params> {
        public final Matrix4f model = new Matrix4f();
        public final Matrix3f normal = new Matrix3f();
        public boolean useParamColor;
        public int r;
        public int g;
        public int b;
        public int a;
        public SpriteShiftFunc spriteShiftFunc;
        public int overlay;
        public boolean useParamLight;
        public int packedLightCoords;

        public void loadDefault() {
            this.model.m_27624_();
            this.normal.m_8180_();
            this.useParamColor = true;
            this.r = 255;
            this.g = 255;
            this.b = 255;
            this.a = 255;
            this.spriteShiftFunc = null;
            this.overlay = OverlayTexture.f_118083_;
            this.useParamLight = false;
            this.packedLightCoords = 0xF000F0;
        }

        public void load(Params from) {
            this.model.m_162210_(from.model);
            this.normal.m_8169_(from.normal);
            this.useParamColor = from.useParamColor;
            this.r = from.r;
            this.g = from.g;
            this.b = from.b;
            this.a = from.a;
            this.spriteShiftFunc = from.spriteShiftFunc;
            this.overlay = from.overlay;
            this.useParamLight = from.useParamLight;
            this.packedLightCoords = from.packedLightCoords;
        }

        public Params color(int r, int g, int b, int a) {
            this.useParamColor = true;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Params color(byte r, byte g, byte b, byte a) {
            this.useParamColor = true;
            this.r = Byte.toUnsignedInt(r);
            this.g = Byte.toUnsignedInt(g);
            this.b = Byte.toUnsignedInt(b);
            this.a = Byte.toUnsignedInt(a);
            return this;
        }

        public Params color(int color) {
            this.useParamColor = true;
            this.r = color >> 16 & 0xFF;
            this.g = color >> 8 & 0xFF;
            this.b = color & 0xFF;
            this.a = 255;
            return this;
        }

        public Params shiftUV(SpriteShiftFunc entry) {
            this.spriteShiftFunc = entry;
            return this;
        }

        public Params overlay(int overlay) {
            this.overlay = overlay;
            return this;
        }

        public Params light(int packedLightCoords) {
            this.useParamLight = true;
            this.packedLightCoords = packedLightCoords;
            return this;
        }

        @Override
        public Params multiply(Quaternion quaternion) {
            this.model.m_27646_(quaternion);
            this.normal.m_8171_(quaternion);
            return this;
        }

        @Override
        public Params scale(float pX, float pY, float pZ) {
            this.model.m_27644_(Matrix4f.m_27632_((float)pX, (float)pY, (float)pZ));
            if (pX == pY && pY == pZ) {
                if (pX > 0.0f) {
                    return this;
                }
                this.normal.m_8156_(-1.0f);
            }
            float f = 1.0f / pX;
            float f1 = 1.0f / pY;
            float f2 = 1.0f / pZ;
            float f3 = Mth.m_14199_((float)(f * f1 * f2));
            this.normal.m_8178_(Matrix3f.m_8174_((float)(f3 * f), (float)(f3 * f1), (float)(f3 * f2)));
            return this;
        }

        @Override
        public Params translate(double x, double y, double z) {
            this.model.m_162199_((float)x, (float)y, (float)z);
            return this;
        }

        @Override
        public Params mulPose(Matrix4f pose) {
            this.model.m_27644_(pose);
            return this;
        }

        @Override
        public Params mulNormal(Matrix3f normal) {
            this.normal.m_8178_(normal);
            return this;
        }
    }

    @FunctionalInterface
    public static interface SpriteShiftFunc {
        public void shift(VertexConsumer var1, float var2, float var3);
    }
}

