/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.core.layout.BufferLayout;
import com.jozufozu.flywheel.core.layout.CommonItems;
import com.jozufozu.flywheel.core.vertex.PosTexNormalVertexListUnsafe;
import com.jozufozu.flywheel.core.vertex.PosTexNormalWriterUnsafe;
import java.nio.ByteBuffer;

public class PosTexNormalVertex
implements VertexType {
    public static final BufferLayout FORMAT = BufferLayout.builder().addItems(CommonItems.VEC3, CommonItems.UV, CommonItems.NORMAL).build();

    @Override
    public BufferLayout getLayout() {
        return FORMAT;
    }

    @Override
    public PosTexNormalWriterUnsafe createWriter(ByteBuffer buffer) {
        return new PosTexNormalWriterUnsafe(this, buffer);
    }

    @Override
    public PosTexNormalVertexListUnsafe createReader(ByteBuffer buffer, int vertexCount) {
        return new PosTexNormalVertexListUnsafe(buffer, vertexCount);
    }

    @Override
    public String getShaderHeader() {
        return "layout (location = 0) in vec3 _flw_v_pos;\nlayout (location = 1) in vec2 _flw_v_texCoords;\nlayout (location = 2) in vec3 _flw_v_normal;\n\nVertex FLWCreateVertex() {\n\tVertex v;\n\tv.pos = _flw_v_pos;\n\tv.color = vec4(1.);\n\tv.texCoords = _flw_v_texCoords;\n\tv.light = vec2(0.);\n\tv.normal = _flw_v_normal;\n\treturn v;\n}\n";
    }
}

